﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/Patch.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class DescribeAvailablePatchesResult {
 public:
  AWS_SSM_API DescribeAvailablePatchesResult() = default;
  AWS_SSM_API DescribeAvailablePatchesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API DescribeAvailablePatchesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of patches. Each entry in the array is a patch structure.</p>
   */
  inline const Aws::Vector<Patch>& GetPatches() const { return m_patches; }
  template <typename PatchesT = Aws::Vector<Patch>>
  void SetPatches(PatchesT&& value) {
    m_patchesHasBeenSet = true;
    m_patches = std::forward<PatchesT>(value);
  }
  template <typename PatchesT = Aws::Vector<Patch>>
  DescribeAvailablePatchesResult& WithPatches(PatchesT&& value) {
    SetPatches(std::forward<PatchesT>(value));
    return *this;
  }
  template <typename PatchesT = Patch>
  DescribeAvailablePatchesResult& AddPatches(PatchesT&& value) {
    m_patchesHasBeenSet = true;
    m_patches.emplace_back(std::forward<PatchesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use when requesting the next set of items. If there are no
   * additional items to return, the string is empty.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeAvailablePatchesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeAvailablePatchesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Patch> m_patches;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_patchesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
