/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.felix.resolver.Blame;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.PermutationType;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.UsedBlames;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.util.CandidateSelector;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

class ResolveSession
implements Runnable {
    private final ResolveContext m_resolveContext;
    private final Collection<Resource> m_mandatoryResources;
    private final Collection<Resource> m_optionalResources;
    private final Resource m_dynamicHost;
    private final Requirement m_dynamicReq;
    private final List<Capability> m_dynamicCandidates;
    private Map<Resource, Boolean> m_validRelatedResources = new HashMap<Resource, Boolean>(0);
    private Map<Resource, Collection<Resource>> m_relatedResources = new HashMap<Resource, Collection<Resource>>(0);
    private final List<Candidates> m_usesPermutations = new LinkedList<Candidates>();
    private int m_usesIndex = 0;
    private final List<Candidates> m_importPermutations = new LinkedList<Candidates>();
    private int m_importIndex = 0;
    private final List<Candidates> m_substPermutations = new LinkedList<Candidates>();
    private int m_substituteIndex = 0;
    private Candidates m_multipleCardCandidates = null;
    private final Set<Object> m_processedDeltas = new HashSet<Object>();
    private final Executor m_executor;
    private final Set<Requirement> m_mutated = new HashSet<Requirement>();
    private final Set<Requirement> m_sub_mutated = new HashSet<Requirement>();
    private final ConcurrentMap<String, List<String>> m_usesCache = new ConcurrentHashMap<String, List<String>>();
    private ResolutionError m_currentError;
    private volatile CancellationException m_isCancelled = null;
    private final Logger logger;

    static ResolveSession createSession(ResolveContext resolveContext, Executor executor, Resource dynamicHost, Requirement dynamicReq, List<Capability> dynamicCandidates, Logger logger) {
        ResolveSession session = new ResolveSession(resolveContext, executor, dynamicHost, dynamicReq, dynamicCandidates, logger);
        session.getContext().onCancel(session);
        session.initMandatoryAndOptionalResources();
        return session;
    }

    private ResolveSession(ResolveContext resolveContext, Executor executor, Resource dynamicHost, Requirement dynamicReq, List<Capability> dynamicCandidates, Logger logger) {
        this.m_resolveContext = resolveContext;
        this.m_executor = executor;
        this.m_dynamicHost = dynamicHost;
        this.m_dynamicReq = dynamicReq;
        this.m_dynamicCandidates = dynamicCandidates;
        this.logger = logger;
        if (this.m_dynamicHost != null) {
            this.m_mandatoryResources = Collections.singletonList(dynamicHost);
            this.m_optionalResources = Collections.emptyList();
        } else {
            this.m_mandatoryResources = new ArrayList<Resource>();
            this.m_optionalResources = new ArrayList<Resource>();
        }
    }

    private void initMandatoryAndOptionalResources() {
        if (!this.isDynamic()) {
            this.m_mandatoryResources.addAll(this.getContext().getMandatoryResources());
            this.m_optionalResources.addAll(this.getContext().getOptionalResources());
        }
    }

    Candidates getMultipleCardCandidates() {
        return this.m_multipleCardCandidates;
    }

    ResolveContext getContext() {
        return this.m_resolveContext;
    }

    ConcurrentMap<String, List<String>> getUsesCache() {
        return this.m_usesCache;
    }

    public Logger getLogger() {
        return this.logger;
    }

    void permutateIfNeeded(PermutationType type, Requirement req, Candidates permutation) {
        List<Capability> candidates = permutation.getCandidates(req);
        if (candidates != null && candidates.size() > 1) {
            if (type == PermutationType.SUBSTITUTE ? !this.m_sub_mutated.add(req) : !this.m_mutated.add(req)) {
                return;
            }
            this.addPermutation(type, permutation.permutate(req));
        }
    }

    private void clearMutateIndexes() {
        this.m_usesIndex = 0;
        this.m_importIndex = 0;
        this.m_substituteIndex = 0;
        this.m_mutated.clear();
    }

    void addPermutation(PermutationType type, Candidates permutation) {
        if (permutation != null) {
            List<Candidates> typeToAddTo = null;
            try {
                switch (type) {
                    case USES: {
                        typeToAddTo = this.m_usesPermutations;
                        this.m_usesPermutations.add(this.m_usesIndex++, permutation);
                        break;
                    }
                    case IMPORT: {
                        typeToAddTo = this.m_importPermutations;
                        this.m_importPermutations.add(this.m_importIndex++, permutation);
                        break;
                    }
                    case SUBSTITUTE: {
                        typeToAddTo = this.m_substPermutations;
                        this.m_substPermutations.add(this.m_substituteIndex++, permutation);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown permutation type: " + (Object)((Object)type));
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                typeToAddTo.add(permutation);
            }
            this.logger.logPermutationAdded(type);
        }
    }

    Candidates getNextPermutation() {
        Candidates next = null;
        do {
            PermutationType type;
            if (!this.m_usesPermutations.isEmpty()) {
                next = this.m_usesPermutations.remove(0);
                type = PermutationType.USES;
            } else if (!this.m_importPermutations.isEmpty()) {
                next = this.m_importPermutations.remove(0);
                type = PermutationType.IMPORT;
            } else if (!this.m_substPermutations.isEmpty()) {
                next = this.m_substPermutations.remove(0);
                type = PermutationType.SUBSTITUTE;
            } else {
                return null;
            }
            this.logger.logProcessPermutation(type);
        } while (!this.m_processedDeltas.add(next.getDelta()));
        this.m_multipleCardCandidates = null;
        this.clearMutateIndexes();
        return next;
    }

    void clearPermutations() {
        this.m_usesPermutations.clear();
        this.m_importPermutations.clear();
        this.m_substPermutations.clear();
        this.m_multipleCardCandidates = null;
        this.m_processedDeltas.clear();
        this.m_currentError = null;
    }

    boolean checkMultiple(UsedBlames usedBlames, Blame usedBlame, Candidates permutation) {
        CandidateSelector candidates = null;
        Requirement req = usedBlame.m_reqs.get(0);
        if (Util.isMultiple(req)) {
            if (this.m_multipleCardCandidates == null) {
                this.m_multipleCardCandidates = permutation.copy();
            }
            candidates = this.m_multipleCardCandidates.clearMultipleCardinalityCandidates(req, usedBlames.getRootCauses(req));
        }
        return candidates != null && !candidates.isEmpty();
    }

    long getPermutationCount() {
        return this.m_usesPermutations.size() + this.m_importPermutations.size() + this.m_substPermutations.size();
    }

    Executor getExecutor() {
        return this.m_executor;
    }

    ResolutionError getCurrentError() {
        return this.m_currentError;
    }

    void setCurrentError(ResolutionError error) {
        this.m_currentError = error;
    }

    boolean isDynamic() {
        return this.m_dynamicHost != null;
    }

    Collection<Resource> getMandatoryResources() {
        return this.m_mandatoryResources;
    }

    Collection<Resource> getOptionalResources() {
        return this.m_optionalResources;
    }

    Resource getDynamicHost() {
        return this.m_dynamicHost;
    }

    Requirement getDynamicRequirement() {
        return this.m_dynamicReq;
    }

    List<Capability> getDynamicCandidates() {
        return this.m_dynamicCandidates;
    }

    public boolean isValidRelatedResource(Resource resource) {
        Boolean valid = this.m_validRelatedResources.get(resource);
        if (valid == null) {
            this.m_validRelatedResources.put(resource, Boolean.TRUE);
            valid = Boolean.TRUE;
        }
        return valid;
    }

    public boolean invalidateRelatedResource(Resource faultyResource) {
        Boolean valid = this.m_validRelatedResources.get(faultyResource);
        if (valid != null && valid.booleanValue()) {
            this.m_validRelatedResources.put(faultyResource, Boolean.FALSE);
            return true;
        }
        return false;
    }

    public Collection<Resource> getRelatedResources(Resource resource) {
        Collection<Resource> related = this.m_relatedResources.get(resource);
        return related == null ? Collections.emptyList() : related;
    }

    public void setRelatedResources(Resource resource, Collection<Resource> related) {
        this.m_relatedResources.put(resource, related);
    }

    @Override
    public void run() {
        this.m_isCancelled = new CancellationException();
    }

    boolean isCancelled() {
        return this.m_isCancelled != null;
    }

    void checkForCancel() throws ResolutionException {
        if (this.isCancelled()) {
            throw new ResolutionException("Resolver operation has been cancelled.", this.m_isCancelled, null);
        }
    }
}

