# CVE-2020-0796 PoC aka CoronaBlue aka SMBGhost

Download ~ https://gitlab.com/exploit-database/exploitdb-bin-sploits/-/raw/main/bin-sploits/48216.zip

## Usage

`./CVE-2020-0796.py servername`

This script connects to the target host, and compresses the authentication request with a bad offset field set in the transformation header, causing the decompressor to buffer overflow and crash the target.

This contains a modification of the excellent [smbprotocol](https://github.com/jborean93/smbprotocol) with added support for SMB 3.1.1 compression/decompression (only LZNT1). Most of the additions are in `smbprotocol/connection.py`. A version of [lznt1](https://github.com/you0708/lznt1) is included, modified to support Python 3.

The compression transform header is in the `SMB2CompressionTransformHeader` class there. The function `_compress` is called to compress tree requests. This is where the offset field is set all high to trigger the crash.

```python
    def _compress(self, b_data, session):
        header = SMB2CompressionTransformHeader()
        header['original_size'] = len(b_data)
        header['offset'] = 4294967295
        header['data'] = smbprotocol.lznt1.compress(b_data)
```

## About

CVE-2020-0796 is a bug in Windows 10 1903/1909's new SMB3 compression capability. SMB protocol version 3.1.1 introduces the ability for a client or server to advertise compression cabilities, and to selectively compress SMB3 messages as beneficial. To accomplish this, when negotiating an SMB session, the client and server must both include a `SMB2_COMPRESSION_CAPABILITIES` as documented in [MS-SMB2 2.2.3.1.3](https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-smb2/78e0c942-ab41-472b-b117-4a95ebe88271).

Once a session is negotiated with this capability, either the client or the server can selectively compress certain SMB messages. To do so, the entire SMB packet is compressed, and a transformed header is prepended, as documented in [MS-SMB2 2.2.42](https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-smb2/1d435f21-9a21-4f4c-828e-624a176cf2a0). This header is a small (16 bytes) structure with a magic value, the uncompressed data size, the compression algorithm used, and an offset value.

CVE-2020-0796 is caused by a lack of bounds checking in that offset size, which is directly passed to several subroutines. Passing a large value in will cause a buffer overflow, and crash the kernel. With further work, this could be developed into a RCE exploit.