/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.script.FormulaCache;
import org.freeplane.plugin.script.FormulaDependencies;
import org.freeplane.plugin.script.FormulaUtils;

public class FormulaUpdateChangeListener
implements INodeChangeListener,
IMapChangeListener,
IMapLifeCycleListener {
    public int priority() {
        return 1;
    }

    public void nodeChanged(NodeChangeEvent event) {
        if (!FormulaCache.class.equals(event.getProperty())) {
            this.reevaluateNodeDependencies(false, event.getNode());
        }
    }

    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
        NodeModel child = nodeDeletionEvent.node;
        this.refreshChangedClones(child);
    }

    private void refreshChangedClones(NodeModel node) {
        if (node.isCloneNode()) {
            this.reevaluateNodeDependencies(true, node);
        }
    }

    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        this.reevaluateNodeDependencies(true, nodeDeletionEvent.parent);
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.reevaluateNodeDependencies(true, parent);
        this.refreshChangedClones(child);
    }

    private void reevaluateNodeDependencies(boolean includeChanged, NodeModel parent) {
        this.reevaluateNodeDependencies(includeChanged, Collections.singletonList(parent));
    }

    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        this.reevaluateNodeDependencies(true, Arrays.asList(nodeMoveEvent.oldParent, nodeMoveEvent.newParent));
    }

    public void mapChanged(MapChangeEvent event) {
        if ("map_url".equals(event.getProperty())) {
            FormulaUtils.clearCache((MapModel)event.getMap());
        }
        if ("GLOBAL_NODES".equals(event.getProperty())) {
            this.globalNodesChanged(event.getMap());
        }
    }

    private void globalNodesChanged(MapModel map) {
        List dependencies = FormulaDependencies.manageChangeAndReturnGlobalDependencies((MapModel)map);
        this.refresh(dependencies);
    }

    private void refresh(List<NodeModel> dependencies) {
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel dependentNode : dependencies) {
            modeController.getMapController().delayedNodeRefresh(dependentNode, FormulaCache.class, null, null);
        }
    }

    private void reevaluateNodeDependencies(boolean includeChanged, Collection<NodeModel> nodes) {
        List dependencies = FormulaDependencies.manageChangeAndReturnDependencies((boolean)includeChanged, nodes);
        this.refresh(dependencies);
    }

    public void onRemove(MapModel map) {
        List dependencies = FormulaDependencies.removeAndReturnMapDependencies((MapModel)map);
        this.refresh(dependencies);
    }
}

