/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.AManageConditionalStylesAction;

public class ManageMapConditionalStylesAction
extends AManageConditionalStylesAction {
    public static final String NAME = "ManageConditionalStylesAction";
    private static final long serialVersionUID = 1L;

    public ManageMapConditionalStylesAction() {
        super(NAME);
    }

    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        ConditionalStyleModel conditionalStyleModel = this.getConditionalStyleModel();
        Component pane = this.createConditionalStylePane(map, conditionalStyleModel, FilterConditionEditor.Variant.FILTER_COMPOSER);
        Controller.getCurrentModeController().startTransaction();
        try {
            int confirmed = JOptionPane.showConfirmDialog(controller.getMapViewManager().getMapViewComponent(), pane, TextUtils.getText((String)TextUtils.removeMnemonic((String)"ManageConditionalStylesAction.text")), 2, -1);
            if (0 == confirmed) {
                LogicalStyleController.getController().refreshMapLaterUndoable(map);
                Controller.getCurrentModeController().commit();
            } else {
                Controller.getCurrentModeController().rollback();
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            Controller.getCurrentModeController().rollback();
        }
    }

    @Override
    public ConditionalStyleModel getConditionalStyleModel() {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        MapStyleModel styleModel = MapStyleModel.getExtension((MapModel)map);
        ConditionalStyleModel conditionalStyleModel = styleModel.getConditionalStyleModel();
        return conditionalStyleModel;
    }
}

