/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.parser.LengthHandler;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.UnitProcessor;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGLength
implements SVGLength {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected short unitType;
    protected float value;
    protected short direction;
    protected UnitProcessor.Context context = new DefaultContext();

    protected abstract SVGOMElement getAssociatedElement();

    public AbstractSVGLength(short direction) {
        this.direction = direction;
        this.value = 0.0f;
        this.unitType = 0;
    }

    public short getCSSUnitType() {
        this.revalidate();
        return this.unitType;
    }

    public short getUnitType() {
        return AbstractSVGLength.getSVGUnitType(this.getCSSUnitType());
    }

    private static short getSVGUnitType(short cssUnit) {
        short svgUnit;
        switch (cssUnit) {
            case 0: {
                svgUnit = 1;
                break;
            }
            case 3: {
                svgUnit = 5;
                break;
            }
            case 20: {
                svgUnit = 3;
                break;
            }
            case 21: {
                svgUnit = 4;
                break;
            }
            case 4: {
                svgUnit = 8;
                break;
            }
            case 7: {
                svgUnit = 6;
                break;
            }
            case 8: {
                svgUnit = 7;
                break;
            }
            case 5: {
                svgUnit = 10;
                break;
            }
            case 6: {
                svgUnit = 9;
                break;
            }
            case 2: {
                svgUnit = 2;
                break;
            }
            default: {
                svgUnit = 0;
            }
        }
        return svgUnit;
    }

    public float getValue() {
        this.revalidate();
        try {
            return UnitProcessor.cssToUserSpace((float)this.value, (short)this.unitType, (short)this.direction, (UnitProcessor.Context)this.context);
        }
        catch (IllegalArgumentException ex) {
            return 0.0f;
        }
    }

    public void setValue(float value) throws DOMException {
        this.value = UnitProcessor.userSpaceToCSS((float)value, (short)this.unitType, (short)this.direction, (UnitProcessor.Context)this.context);
        this.reset();
    }

    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    public void setValueInSpecifiedUnits(float value) throws DOMException {
        this.revalidate();
        this.value = value;
        this.reset();
    }

    public String getValueAsString() {
        this.revalidate();
        if (this.unitType == 255) {
            return "";
        }
        return Float.toString(this.value) + CSSUnit.dimensionUnitString((short)this.unitType);
    }

    public void setValueAsString(String value) throws DOMException {
        this.parse(value);
        this.reset();
    }

    public void newValueSpecifiedCSSUnits(short unit, float value) {
        this.unitType = unit;
        this.value = value;
        this.reset();
    }

    public void newValueSpecifiedUnits(short unitType, float valueInSpecifiedUnits) throws DOMException {
        this.newValueSpecifiedCSSUnits(AbstractSVGLength.getCSSUnitType(unitType), valueInSpecifiedUnits);
    }

    private static short getCSSUnitType(short svgUnit) throws DOMException {
        short cssUnit;
        switch (svgUnit) {
            case 1: {
                cssUnit = 0;
                break;
            }
            case 5: {
                cssUnit = 3;
                break;
            }
            case 3: {
                cssUnit = 20;
                break;
            }
            case 4: {
                cssUnit = 21;
                break;
            }
            case 8: {
                cssUnit = 4;
                break;
            }
            case 6: {
                cssUnit = 7;
                break;
            }
            case 7: {
                cssUnit = 8;
                break;
            }
            case 10: {
                cssUnit = 5;
                break;
            }
            case 9: {
                cssUnit = 6;
                break;
            }
            case 2: {
                cssUnit = 2;
                break;
            }
            default: {
                throw new DOMException(9, "Unit not supported: " + svgUnit);
            }
        }
        return cssUnit;
    }

    public void convertToSpecifiedUnits(short unit) throws DOMException {
        float v = this.getValue();
        v = NumberValue.floatValueConversion((float)v, (short)this.unitType, (short)AbstractSVGLength.getCSSUnitType(unit));
        this.unitType = unit;
        this.setValue(v);
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String s) {
        try {
            UnitProcessor.UnitResolver ur = new UnitProcessor.UnitResolver(){

                protected float unitToPixels(short unitType, float floatValue, short pcntInterp) {
                    return UnitProcessor.cssToUserSpace((float)floatValue, (short)unitType, (short)AbstractSVGLength.this.direction, (UnitProcessor.Context)AbstractSVGLength.this.context);
                }
            };
            LengthParser lengthParser = new LengthParser((LengthHandler)ur);
            lengthParser.parse(s);
            this.unitType = ur.unit;
            this.value = ur.value;
        }
        catch (ParseException e) {
            this.unitType = (short)255;
            this.value = 0.0f;
        }
    }

    protected class DefaultContext
    implements UnitProcessor.Context {
        protected DefaultContext() {
        }

        public Element getElement() {
            return AbstractSVGLength.this.getAssociatedElement();
        }

        public float getResolution() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getResolution();
        }

        public float getFontSize() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getFontSize();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getLineHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getLineHeight();
        }

        public float getRootFontSize() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getRootFontSize();
        }

        public float getRootXHeight() {
            return 0.5f;
        }

        public float getRootLineHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getRootLineHeight();
        }

        public float getViewportWidth() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportWidth();
        }

        public float getViewportHeight() {
            return AbstractSVGLength.this.getAssociatedElement().getSVGContext().getViewportHeight();
        }
    }
}

