/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.XYZColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class XYZColorImpl
extends BaseColor
implements XYZColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue x = null;
    private PrimitiveValue y = null;
    private PrimitiveValue z = null;
    private final Illuminant refWhite;

    XYZColorImpl(Illuminant white) {
        this.refWhite = white;
    }

    XYZColorImpl(XYZColorImpl copyMe) {
        this.refWhite = copyMe.refWhite;
        if (copyMe.x != null) {
            this.x = copyMe.x.clone();
        }
        if (copyMe.y != null) {
            this.y = copyMe.y.clone();
        }
        if (copyMe.z != null) {
            this.z = copyMe.z.clone();
        }
        this.alpha = copyMe.alpha.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.XYZ;
    }

    @Override
    public String getColorSpace() {
        return this.refWhite == Illuminant.D50 ? "xyz-d50" : "xyz";
    }

    @Override
    BaseColor.Space getSpace() {
        return this.refWhite == Illuminant.D50 ? BaseColor.Space.CIE_XYZ_D50 : BaseColor.Space.CIE_XYZ;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        XYZColorImpl xyzcolor = (XYZColorImpl)color;
        this.x = xyzcolor.x;
        this.y = xyzcolor.y;
        this.z = xyzcolor.z;
    }

    @Override
    public NumberValue component(String component) {
        NumberValue ret;
        switch (component) {
            case "x": {
                ret = this.numberComponent((TypedValue)this.getX(), 1.0f);
                break;
            }
            case "y": {
                ret = this.numberComponent((TypedValue)this.getY(), 1.0f);
                break;
            }
            case "z": {
                ret = this.numberComponent((TypedValue)this.getZ(), 1.0f);
                break;
            }
            case "alpha": {
                ret = this.numberComponent((TypedValue)this.alpha, 100.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getX();
            }
            case 2: {
                return this.getY();
            }
            case 3: {
                return this.getZ();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setX(component);
                break;
            }
            case 2: {
                this.setY(component);
                break;
            }
            case 3: {
                this.setZ(component);
            }
        }
    }

    @Override
    public PrimitiveValue getX() {
        return this.x;
    }

    public void setX(PrimitiveValue x) {
        this.x = this.normalizeAxisComponent(x);
    }

    @Override
    public PrimitiveValue getY() {
        return this.y;
    }

    public void setY(PrimitiveValue y) {
        this.y = this.normalizeAxisComponent(y);
    }

    @Override
    public PrimitiveValue getZ() {
        return this.z;
    }

    public void setZ(PrimitiveValue z) {
        this.z = this.normalizeAxisComponent(z);
    }

    private PrimitiveValue normalizeAxisComponent(PrimitiveValue axis) {
        return XYZColorImpl.normalizePcntToNumber(axis, 0.01f, 5, true);
    }

    @Override
    boolean hasPercentageComponent() {
        return this.x != null && this.x.getUnitType() == 2 || this.y != null && this.y.getUnitType() == 2 || this.z != null && this.z.getUnitType() == 2;
    }

    @Override
    boolean hasConvertibleComponents() {
        return XYZColorImpl.isConvertibleComponent(this.getX()) && XYZColorImpl.isConvertibleComponent(this.getY()) && XYZColorImpl.isConvertibleComponent(this.getZ());
    }

    @Override
    int getMaximumFractionDigits() {
        return 5;
    }

    @Override
    void setColorComponents(double[] xyz) {
        NumberValue x = NumberValue.createCSSNumberValue((short)0, (float)xyz[0]);
        x.setSubproperty(true);
        x.setAbsolutizedUnit();
        x.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setX(x);
        NumberValue y = NumberValue.createCSSNumberValue((short)0, (float)xyz[1]);
        y.setSubproperty(true);
        y.setAbsolutizedUnit();
        y.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setY(y);
        NumberValue z = NumberValue.createCSSNumberValue((short)0, (float)xyz[2]);
        z.setSubproperty(true);
        z.setAbsolutizedUnit();
        z.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setZ(z);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] xyz = new double[]{ColorUtil.floatNumber((TypedValue)this.x), ColorUtil.floatNumber((TypedValue)this.y), ColorUtil.floatNumber((TypedValue)this.z)};
        return xyz;
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] xyz = this.toNumberArray();
        if (this.refWhite != white) {
            xyz = white == Illuminant.D50 ? ColorUtil.d65xyzToD50(xyz) : ColorUtil.d50xyzToD65(xyz);
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] xyz = this.toNumberArray();
        if (this.refWhite == Illuminant.D50) {
            if (!Arrays.equals(Illuminants.whiteD50, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        } else if (!Arrays.equals(Illuminants.whiteD65, white)) {
            double[][] cam = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, white, cam);
            double[] result = new double[3];
            Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
            xyz = result;
        }
        return xyz;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        double[] xyz = this.toNumberArray();
        double[] xyzD65 = this.refWhite == Illuminant.D50 ? ColorUtil.d50xyzToD65(xyz) : xyz;
        double[] rgb = new double[3];
        ColorUtil.d65xyzToSRGB(xyzD65, rgb);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            double[] lab = new double[3];
            if (this.refWhite == Illuminant.D65) {
                xyz = ColorUtil.d65xyzToD50(xyzD65);
            }
            ColorUtil.xyzD50ToLab(xyz, lab);
            SRGBColorProfile profile = new SRGBColorProfile();
            ColorUtil.clampRGB(lab[0], lab[1], lab[2], profile, rgb);
        }
        return rgb;
    }

    RGBAColor toSRGBColor(boolean clamp) {
        double[] rgb = this.toSRGB(clamp);
        RGBColor color = new RGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.getAlpha().clone());
        return color;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.refWhite, this.x, this.y, this.z});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYZColorImpl other = (XYZColorImpl)obj;
        return this.refWhite == other.refWhite && Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y) && Objects.equals(this.z, other.z);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public XYZColorImpl clone() {
        return new XYZColorImpl(this);
    }
}

