/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationSetItem
implements StructConverter {
    private static final int MAX_SANE_COUNT = 4096;
    private int size_;
    private int[] entries_;

    public AnnotationSetItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        this.size_ = reader.readNextInt();
        if (this.size_ > 4096) {
            throw new IOException("Too many annotations specified: 0x" + Integer.toHexString(this.size_));
        }
        this.entries_ = reader.readNextIntArray(this.size_);
    }

    public int getSize() {
        return this.size_;
    }

    public int[] getEntries() {
        return this.entries_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("annotation_set_item_" + this.size_, 0);
        structure.add(DWORD, "size_", null);
        if (this.size_ > 0) {
            ArrayDataType array = new ArrayDataType(DWORD, this.size_, DWORD.getLength());
            structure.add((DataType)array, "entries_", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/annotation_set_item"));
        return structure;
    }
}

