/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4Constants;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Ext4XattrEntry
implements StructConverter {
    private byte e_name_len;
    private byte e_name_index;
    private short e_value_offs;
    private int e_value_block;
    private int e_value_size;
    private int e_hash;
    private byte[] e_name;
    private byte[] value;

    public Ext4XattrEntry(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4XattrEntry(BinaryReader reader) throws IOException {
        this.e_name_len = reader.readNextByte();
        this.e_name_index = reader.readNextByte();
        this.e_value_offs = reader.readNextShort();
        this.e_value_block = reader.readNextInt();
        this.e_value_size = reader.readNextInt();
        this.e_hash = reader.readNextInt();
        this.e_name = reader.readNextByteArray((int)this.e_name_len);
    }

    public byte getE_name_len() {
        return this.e_name_len;
    }

    public byte getE_name_index() {
        return this.e_name_index;
    }

    public short getE_value_offs() {
        return this.e_value_offs;
    }

    public int getE_value_block() {
        return this.e_value_block;
    }

    public int getE_value_size() {
        return this.e_value_size;
    }

    public int getE_hash() {
        return this.e_hash;
    }

    public byte[] getE_name() {
        return this.e_name;
    }

    public boolean isEndOfListMarker() {
        return this.e_name_len == 0 && this.e_name_index == 0 && this.e_value_offs == 0 && this.e_value_block == 0;
    }

    public boolean isValid() {
        return 0 <= this.e_name_index && this.e_name_index < Ext4Constants.EXT4_XATTR_NAMEINDEX_STRINGS.length;
    }

    public String getName() {
        return Ext4Constants.EXT4_XATTR_NAMEINDEX_STRINGS[this.e_name_index] + new String(this.e_name, StandardCharsets.UTF_8);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_xattr_entry", 0);
        structure.add(BYTE, "e_name_len", null);
        structure.add(BYTE, "e_name_index", null);
        structure.add(WORD, "e_value_offs", null);
        structure.add(DWORD, "e_value_block", null);
        structure.add(DWORD, "e_value_size", null);
        structure.add(DWORD, "e_hash", null);
        structure.add((DataType)new ArrayDataType(BYTE, (int)this.e_name_len, BYTE.getLength()), "e_name", null);
        return structure;
    }
}

