/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgGraphTask;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;

public class PCodeDfgAction
extends AbstractDecompilerAction {
    public PCodeDfgAction() {
        super("Graph PCode Data Flow");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "DataFlowGraph"));
        this.setMenuBarData(new MenuData(new String[]{"Graph Data Flow"}, "graph"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return context.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        GraphDisplayBroker service = (GraphDisplayBroker)tool.getService(GraphDisplayBroker.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"AST Graph Failed", (Object)"Graph Display Broker service not found!\nPlease add a Graph Display Broker service");
            return;
        }
        HighFunction highFunction = context.getHighFunction();
        PCodeDfgGraphTask task = new PCodeDfgGraphTask(tool, service, highFunction);
        new TaskLauncher((Task)task, (Component)tool.getToolFrame());
    }
}

