/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.AccumulatorSizeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class SizeRestrictedAccumulatorWrapper<T>
implements Accumulator<T> {
    private Accumulator<T> accumulator;
    private int maxSize;

    public SizeRestrictedAccumulatorWrapper(Accumulator<T> accumulator, int maxSize) {
        this.accumulator = Objects.requireNonNull(accumulator);
        this.maxSize = maxSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.accumulator.iterator();
    }

    @Override
    public void add(T t) {
        if (this.accumulator.size() >= this.maxSize) {
            throw new AccumulatorSizeException(this.maxSize);
        }
        this.accumulator.add(t);
    }

    @Override
    public void addAll(Collection<T> collection) {
        for (T t : collection) {
            this.accumulator.add(t);
        }
    }

    @Override
    public boolean contains(T t) {
        return this.accumulator.contains(t);
    }

    @Override
    public Collection<T> get() {
        return this.accumulator.get();
    }

    @Override
    public int size() {
        return this.accumulator.size();
    }
}

