/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectLockedException;

public interface DomainObjectLockHold
extends AutoCloseable {
    public static DomainObjectLockHold lock(DomainObject object, String reason) {
        if (object.lock(reason)) {
            return new DefaultHold(object);
        }
        throw new DomainObjectLockedException("Could not get lock");
    }

    public static DomainObjectLockHold forceLock(DomainObject object, boolean rollback, String reason) {
        object.forceLock(rollback, reason);
        return new DefaultHold(object);
    }

    public static class DefaultHold
    implements DomainObjectLockHold {
        final DomainObject object;

        public DefaultHold(DomainObject object) {
            this.object = object;
        }

        @Override
        public void close() throws Exception {
            this.object.unlock();
        }
    }
}

