/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultTransformer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.RenderContextStateChange;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.decorators.ParallelEdgeShapeFunction;
import org.jungrapht.visualization.renderers.EdgeLabelRenderer;
import org.jungrapht.visualization.renderers.JLabelEdgeLabelRenderer;
import org.jungrapht.visualization.renderers.JLabelVertexLabelRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.renderers.VertexLabelRenderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.util.ArrowFactory;
import org.jungrapht.visualization.util.EdgeIndexFunction;
import org.jungrapht.visualization.util.ParallelEdgeIndexFunction;

public class DefaultRenderContext<V, E>
implements RenderContext<V, E> {
    private RenderContextStateChange.Support<V, E> renderContextStateChangeSupport = RenderContextStateChange.Support.create();
    private static final String VERTEX_SHAPE = "jungrapht.vertexShape";
    private static final String VERTEX_SIZE = "jungrapht.vertexSize";
    private static final String VERTEX_DRAW_COLOR = "jungrapht.vertexDrawColor";
    private static final String SELECTED_VERTEX_DRAW_COLOR = "jungrapht.selectedVertexDrawColor";
    private static final String VERTEX_FILL_COLOR = "jungrapht.vertexFillColor";
    private static final String SELECTED_VERTEX_COLOR = "jungrapht.selectedVertexFillColor";
    private static final String VERTEX_STROKE_WIDTH = "jungrapht.vertexStrokeWidth";
    private static final String SELECTED_VERTEX_STROKE_WIDTH = "jungrapht.selectedVertexStrokeWidth";
    private static final String VERTEX_LABEL_FONT = "jungrapht.vertexLabelFont";
    private static final String VERTEX_LABEL_POSITION = "jungrapht.vertexLabelPosition";
    private static final String VERTEX_LABEL_DRAW_COLOR = "jungrapht.vertexLabelDrawColor";
    private static final String EDGE_SHAPE = "jungrapht.edgeShape";
    private static final String EDGE_COLOR = "jungrapht.edgeColor";
    private static final String SELECTED_EDGE_COLOR = "jungrapht.selectedEdgeColor";
    public static final String EDGE_WIDTH = "jungrapht.edgeWidth";
    private static final String EDGE_STROKE = "jungrapht.edgeStroke";
    public static final String SELECTED_EDGE_WIDTH = "jungrapht.selectedEdgeWidth";
    private static final String SELECTED_EDGE_STROKE = "jungrapht.selectedEdgeStroke";
    private static final String EDGE_LABEL_FONT = "jungrapht.edgeLabelFont";
    private static final String EDGE_LABEL_CLOSENESS = "jungrapht.edgeLabelCloseness";
    private static final String ARROW_STYLE = "jungrapht.arrowStyle";
    private static final String EDGE_ARROW_LENGTH = "jungrapht.edgeArrowLength";
    private static final String EDGE_ARROW_WIDTH = "jungrapht.edgeArrowWidth";
    private static final String EDGE_ARROW_NOTCH_DEPTH = "jungrapht.edgeArrowNotchDepth";
    private static final String EDGE_ARROW_STROKE = "jungrapht.edgeArrowStroke";
    private static final String ARROW_PLACEMENT_TOLERANCE = "jungrapht.arrowPlacementTolerance";
    private static final String ARROWS_ON_UNDIRECTED_EDGES = "jungrapht.arrowsOnUndirectedEdges";
    protected MutableSelectedState<V> selectedVertexState;
    protected MutableSelectedState<E> selectedEdgeState;
    protected Stroke edgeStroke;
    protected float edgeStrokeWidth = Float.parseFloat(System.getProperty("jungrapht.edgeWidth", "1.0f"));
    protected float selectedEdgeStrokeWidth = Float.parseFloat(System.getProperty("jungrapht.selectedEdgeWidth", "1.0f"));
    private int vertexSize = Integer.getInteger("jungrapht.vertexSize", 20);
    private String vertexShapeString = System.getProperty("jungrapht.vertexShape", "CIRCLE");
    private Paint vertexDrawPaint = Color.getColor("jungrapht.vertexDrawColor", Color.BLACK);
    private Paint selectedVertexDrawPaint = Color.getColor("jungrapht.selectedVertexDrawColor", Color.BLACK);
    private Paint vertexFillPaint = Color.getColor("jungrapht.vertexFillColor", Color.RED);
    private Paint selectedVertexFillPaint = Color.getColor("jungrapht.selectedVertexFillColor", Color.YELLOW);
    private Shape vertexShape = DefaultRenderContext.getVertexShape(this.vertexShapeString, this.vertexSize);
    protected Predicate<V> vertexIncludePredicate = n -> true;
    protected Function<V, Stroke> vertexStrokeFunction = n -> new BasicStroke(Float.parseFloat(System.getProperty(VERTEX_STROKE_WIDTH, "1.0")));
    protected Function<V, Stroke> selectedVertexStrokeFunction = n -> new BasicStroke(Float.parseFloat(System.getProperty(SELECTED_VERTEX_STROKE_WIDTH, "1.0")));
    protected Function<V, Shape> vertexShapeFunction = v -> this.vertexShape;
    protected Function<V, Paint> vertexDrawPaintFunction = n -> this.vertexDrawPaint;
    protected Function<V, Paint> selectedVertexDrawPaintFunction = n -> this.selectedVertexDrawPaint;
    protected Function<V, Paint> vertexFillPaintFunction = n -> this.vertexFillPaint;
    protected Function<V, Paint> selectedVertexFillPaintFunction = n -> this.selectedVertexFillPaint;
    private Font vertexFont = Font.getFont("jungrapht.vertexLabelFont", new Font("Helvetica", 0, 12));
    private Paint vertexLabelDrawPaint = Color.getColor("jungrapht.vertexLabelDrawColor", Color.BLACK);
    private Renderer.VertexLabel.Position vertexLabelPosition = this.getPosition(System.getProperty("jungrapht.vertexLabelPosition"));
    protected Function<V, Font> vertexFontFunction = n -> this.vertexFont;
    protected Function<V, Paint> vertexLabelDrawPaintFunction = n -> this.vertexLabelDrawPaint;
    private float edgeWidth = Float.parseFloat(System.getProperty("jungrapht.edgeWidth", "1.0f"));
    private Color selectedEdgePaint = Color.getColor("jungrapht.selectedEdgeColor", Color.CYAN);
    private Color edgePaint = Color.getColor("jungrapht.edgeColor", Color.BLACK);
    protected Function<E, Stroke> edgeStrokeFunction = e -> this.edgeStroke;
    protected Function<E, Paint> edgeFillPaintFunction = n -> null;
    protected Function<E, Paint> selectedEdgeFillPaintFunction = n -> null;
    protected Function<E, Paint> edgeDrawPaintFunction = e -> this.edgePaint;
    protected Function<E, Paint> selectedEdgeDrawPaintFunction = e -> this.selectedEdgePaint;
    private Font edgeLabelFont = Font.getFont("jungrapht.edgeLabelFont", new Font("Helvetica", 0, 12));
    protected Function<E, Font> edgeFontFunction = n -> this.edgeLabelFont;
    protected Function<E, String> edgeLabelFunction = e -> null;
    private int edgeArrowLength = Integer.getInteger("jungrapht.edgeArrowLength", 10);
    private int edgeArrowWidth = Integer.getInteger("jungrapht.edgeArrowWidth", 8);
    private double edgeArrowNotchDepth = Double.parseDouble(System.getProperty("jungrapht.edgeArrowNotchDepth", "0.4"));
    protected Shape edgeArrow;
    protected float arrowPlacementTolerance = Float.parseFloat(System.getProperty("jungrapht.arrowPlacementTolerance", "1.0"));
    protected Stroke edgeArrowStroke = new BasicStroke(Float.parseFloat(System.getProperty("jungrapht.edgeArrowStroke", "1.0")));
    protected Function<E, Stroke> edgeArrowStrokeFunction = e -> this.edgeArrowStroke;
    protected Function<E, Paint> arrowFillPaintFunction = e -> this.selectedEdgeState != null && this.selectedEdgeState.isSelected(e) ? this.selectedEdgePaint : this.edgePaint;
    protected Function<E, Paint> arrowDrawPaintFunction = e -> this.selectedEdgeState != null && this.selectedEdgeState.isSelected(e) ? this.selectedEdgePaint : this.edgePaint;
    protected boolean arrowsOnUndirectedEdges = Boolean.parseBoolean(System.getProperty("jungrapht.arrowsOnUndirectedEdges", "false"));
    protected Function<V, String> vertexLabelFunction = n -> null;
    protected Function<V, Icon> vertexIconFunction;
    protected boolean renderEdgeArrow;
    protected Predicate<E> edgeIncludePredicate = n -> true;
    private float edgeLabelCloseness = Float.parseFloat(System.getProperty("jungrapht.edgeLabelCloseness", "0.65f"));
    protected BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction;
    protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;
    protected MultiLayerTransformer multiLayerTransformer = new DefaultTransformer();
    protected GraphElementAccessor<V, E> selectionSupport;
    protected int labelOffset = 10;
    protected JComponent screenDevice;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected VertexLabelRenderer vertexLabelRenderer = new JLabelVertexLabelRenderer(Color.blue);
    protected EdgeLabelRenderer edgeLabelRenderer = new JLabelEdgeLabelRenderer(Color.cyan);
    protected GraphicsDecorator graphicsContext;

    @Override
    public RenderContextStateChange.Support getRenderContextStateChangeSupport() {
        return this.renderContextStateChangeSupport;
    }

    DefaultRenderContext() {
        this.parallelEdgeIndexFunction = new ParallelEdgeIndexFunction();
        this.setEdgeShape(System.getProperty(EDGE_SHAPE, "QUAD_CURVE"));
        this.edgeWidth = Float.parseFloat(System.getProperty(EDGE_WIDTH, "1.0f"));
        this.setEdgeStroke(System.getProperty(EDGE_STROKE, "LINE"), this.edgeWidth);
    }

    @Override
    public void setupArrows(boolean directed) {
        if (directed) {
            this.edgeArrow = ArrowFactory.getNotchedArrow(this.edgeArrowWidth, this.edgeArrowLength, (int)((double)this.edgeArrowLength * this.edgeArrowNotchDepth));
            this.renderEdgeArrow = true;
        } else {
            this.edgeArrow = ArrowFactory.getWedgeArrow(this.edgeArrowWidth, this.edgeArrowLength);
            this.renderEdgeArrow = this.arrowsOnUndirectedEdges;
        }
    }

    @Override
    public Function<V, Shape> getVertexShapeFunction() {
        return this.vertexShapeFunction;
    }

    @Override
    public void setVertexShapeFunction(Function<V, Shape> vertexShapeFunction) {
        this.vertexShapeFunction = vertexShapeFunction;
        this.renderContextStateChangeSupport.fireRenderContextStateChanged(this, true);
    }

    @Override
    public Function<V, Stroke> getVertexStrokeFunction() {
        return this.vertexStrokeFunction;
    }

    @Override
    public void setVertexStrokeFunction(Function<V, Stroke> vertexStrokeFunction) {
        this.vertexStrokeFunction = vertexStrokeFunction;
    }

    @Override
    public Function<V, Stroke> getSelectedVertexStrokeFunction() {
        return this.selectedVertexStrokeFunction;
    }

    @Override
    public void setSelectedVertexStrokeFunction(Function<V, Stroke> selectedVertexStrokeFunction) {
        this.selectedVertexStrokeFunction = selectedVertexStrokeFunction;
    }

    public static float[] getDashing() {
        return dashing;
    }

    public static float[] getDotting() {
        return dotting;
    }

    @Override
    public float getArrowPlacementTolerance() {
        return this.arrowPlacementTolerance;
    }

    @Override
    public void setArrowPlacementTolerance(float arrow_placement_tolerance) {
        this.arrowPlacementTolerance = arrow_placement_tolerance;
    }

    @Override
    public Shape getEdgeArrow() {
        return this.edgeArrow;
    }

    @Override
    public void setEdgeArrow(Shape shape) {
        this.edgeArrow = shape;
    }

    @Override
    public boolean renderEdgeArrow() {
        return this.renderEdgeArrow || this.arrowsOnUndirectedEdges;
    }

    @Override
    public void setRenderEdgeArrow(boolean render) {
        this.renderEdgeArrow = render;
    }

    @Override
    public void setEdgeArrowWidth(int edgeArrowWidth) {
        this.edgeArrowWidth = edgeArrowWidth;
    }

    @Override
    public int getEdgeArrowWidth() {
        return this.edgeArrowWidth;
    }

    @Override
    public void setEdgeArrowLength(int edgeArrowLength) {
        this.edgeArrowLength = edgeArrowLength;
    }

    @Override
    public int getEdgeArrowLength() {
        return this.edgeArrowLength;
    }

    @Override
    public void setArrowsOnUndirectedEdges(boolean arrowsOnUndirectedEdges) {
        this.arrowsOnUndirectedEdges = arrowsOnUndirectedEdges;
    }

    @Override
    public boolean getArrowsOnUndirectedEdges() {
        return this.arrowsOnUndirectedEdges;
    }

    @Override
    public Function<E, Font> getEdgeFontFunction() {
        return this.edgeFontFunction;
    }

    @Override
    public void setEdgeFontFunction(Function<E, Font> edgeFontFunction) {
        this.edgeFontFunction = edgeFontFunction;
    }

    @Override
    public Predicate<E> getEdgeIncludePredicate() {
        return this.edgeIncludePredicate;
    }

    @Override
    public void setEdgeIncludePredicate(Predicate<E> edgeIncludePredicate) {
        this.edgeIncludePredicate = edgeIncludePredicate;
    }

    @Override
    public float getEdgeLabelCloseness() {
        return this.edgeLabelCloseness;
    }

    @Override
    public void setEdgeLabelCloseness(float closeness) {
        this.edgeLabelCloseness = closeness;
    }

    @Override
    public EdgeLabelRenderer getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(EdgeLabelRenderer edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public void setEdgeDrawPaintFunction(Function<E, Paint> edgeDrawPaintFunction) {
        this.edgeDrawPaintFunction = edgeDrawPaintFunction;
    }

    @Override
    public Function<E, Paint> getEdgeDrawPaintFunction() {
        return this.edgeDrawPaintFunction;
    }

    @Override
    public Function<E, Paint> getSelectedEdgeDrawPaintFunction() {
        return this.selectedEdgeDrawPaintFunction;
    }

    @Override
    public void setSelectedEdgeDrawPaintFunction(Function<E, Paint> selectedEdgeDrawPaintFunction) {
        this.selectedEdgeDrawPaintFunction = selectedEdgeDrawPaintFunction;
    }

    @Override
    public void setEdgeFillPaintFunction(Function<E, Paint> edgeFillPaintFunction) {
        this.edgeFillPaintFunction = edgeFillPaintFunction;
    }

    @Override
    public Function<E, Paint> getEdgeFillPaintFunction() {
        return this.edgeFillPaintFunction;
    }

    @Override
    public void setSelectedEdgeFillPaintFunction(Function<E, Paint> selectedEdgeFillPaintFunction) {
        this.selectedEdgeFillPaintFunction = selectedEdgeFillPaintFunction;
    }

    @Override
    public Function<E, Paint> getSelectedEdgeFillPaintFunction() {
        return this.selectedEdgeFillPaintFunction;
    }

    @Override
    public BiFunction<Graph<V, E>, E, Shape> getEdgeShapeFunction() {
        return this.edgeShapeFunction;
    }

    @Override
    public void setEdgeShapeFunction(BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction) {
        this.edgeShapeFunction = edgeShapeFunction;
        if (edgeShapeFunction instanceof ParallelEdgeShapeFunction) {
            ParallelEdgeShapeFunction function = (ParallelEdgeShapeFunction)edgeShapeFunction;
            function.setEdgeIndexFunction(this.parallelEdgeIndexFunction);
        }
        this.renderContextStateChangeSupport.fireRenderContextStateChanged(this, true);
    }

    @Override
    public Renderer.VertexLabel.Position getVertexLabelPosition() {
        return this.vertexLabelPosition;
    }

    @Override
    public void setVertexLabelPosition(Renderer.VertexLabel.Position vertexLabelPosition) {
        this.vertexLabelPosition = vertexLabelPosition;
    }

    @Override
    public Function<E, String> getEdgeLabelFunction() {
        return this.edgeLabelFunction;
    }

    @Override
    public void setEdgeLabelFunction(Function<E, String> edgeLabelFunction) {
        this.edgeLabelFunction = edgeLabelFunction;
    }

    @Override
    public Function<E, Stroke> getEdgeStrokeFunction() {
        return this.edgeStrokeFunction;
    }

    @Override
    public void setEdgeStrokeFunction(Function<E, Stroke> edgeStrokeFunction) {
        this.edgeStrokeFunction = edgeStrokeFunction;
    }

    @Override
    public void setEdgeWidth(float edgeWidth) {
        this.edgeWidth = edgeWidth;
    }

    @Override
    public float getEdgeWidth() {
        return this.edgeWidth;
    }

    @Override
    public void setSelectedEdgeWidth(float selectedEdgeWidth) {
    }

    @Override
    public float getSelectedEdgeWidth() {
        return 0.0f;
    }

    @Override
    public Function<E, Stroke> getEdgeArrowStrokeFunction() {
        return this.edgeArrowStrokeFunction;
    }

    @Override
    public void setEdgeArrowStrokeFunction(Function<E, Stroke> edgeArrowStrokeFunction) {
        this.edgeArrowStrokeFunction = edgeArrowStrokeFunction;
    }

    @Override
    public GraphicsDecorator getGraphicsContext() {
        return this.graphicsContext;
    }

    @Override
    public void setGraphicsContext(GraphicsDecorator graphicsContext) {
        this.graphicsContext = graphicsContext;
    }

    @Override
    public int getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    @Override
    public EdgeIndexFunction<V, E> getParallelEdgeIndexFunction() {
        return this.parallelEdgeIndexFunction;
    }

    @Override
    public void setParallelEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
        this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        this.setEdgeShapeFunction(this.getEdgeShapeFunction());
    }

    @Override
    public MutableSelectedState<E> getSelectedEdgeState() {
        return this.selectedEdgeState;
    }

    @Override
    public void setSelectedEdgeState(MutableSelectedState<E> selectedEdgeState) {
        this.selectedEdgeState = selectedEdgeState;
    }

    @Override
    public MutableSelectedState<V> getSelectedVertexState() {
        return this.selectedVertexState;
    }

    @Override
    public void setSelectedVertexState(MutableSelectedState<V> selectedVertexState) {
        this.selectedVertexState = selectedVertexState;
    }

    @Override
    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    @Override
    public void setRendererPane(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    @Override
    public JComponent getScreenDevice() {
        return this.screenDevice;
    }

    @Override
    public void setScreenDevice(JComponent screenDevice) {
        this.screenDevice = screenDevice;
        screenDevice.add(this.rendererPane);
    }

    @Override
    public Function<V, Font> getVertexFontFunction() {
        return this.vertexFontFunction;
    }

    @Override
    public void setVertexFontFunction(Function<V, Font> vertexFontFunction) {
        this.vertexFontFunction = vertexFontFunction;
    }

    @Override
    public Function<V, Icon> getVertexIconFunction() {
        return this.vertexIconFunction;
    }

    @Override
    public void setVertexIconFunction(Function<V, Icon> vertexIconFunction) {
        this.vertexIconFunction = vertexIconFunction;
    }

    @Override
    public Predicate<V> getVertexIncludePredicate() {
        return this.vertexIncludePredicate;
    }

    @Override
    public void setVertexIncludePredicate(Predicate<V> vertexIncludePredicate) {
        this.vertexIncludePredicate = vertexIncludePredicate;
    }

    @Override
    public VertexLabelRenderer getVertexLabelRenderer() {
        return this.vertexLabelRenderer;
    }

    @Override
    public void setVertexLabelRenderer(VertexLabelRenderer vertexLabelRenderer) {
        this.vertexLabelRenderer = vertexLabelRenderer;
    }

    @Override
    public Function<V, Paint> getVertexFillPaintFunction() {
        return this.vertexFillPaintFunction;
    }

    @Override
    public void setVertexFillPaintFunction(Function<V, Paint> vertexFillPaintFunction) {
        this.vertexFillPaintFunction = vertexFillPaintFunction;
    }

    @Override
    public Function<V, Paint> getSelectedVertexFillPaintFunction() {
        return this.selectedVertexFillPaintFunction;
    }

    @Override
    public void setSelectedVertexFillPaintFunction(Function<V, Paint> selectedVertexFillPaintFunction) {
        this.selectedVertexFillPaintFunction = selectedVertexFillPaintFunction;
    }

    @Override
    public Function<V, Paint> getVertexDrawPaintFunction() {
        return this.vertexDrawPaintFunction;
    }

    @Override
    public void setVertexDrawPaintFunction(Function<V, Paint> vertexDrawPaintFunction) {
        this.vertexDrawPaintFunction = vertexDrawPaintFunction;
    }

    @Override
    public Function<V, Paint> getSelectedVertexDrawPaintFunction() {
        return this.selectedVertexDrawPaintFunction;
    }

    @Override
    public void setSelectedVertexDrawPaintFunction(Function<V, Paint> selectedVertexDrawPaintFunction) {
        this.selectedVertexDrawPaintFunction = selectedVertexDrawPaintFunction;
    }

    @Override
    public Function<V, String> getVertexLabelFunction() {
        return this.vertexLabelFunction;
    }

    @Override
    public void setVertexLabelFunction(Function<V, String> vertexLabelFunction) {
        this.vertexLabelFunction = vertexLabelFunction;
    }

    @Override
    public void setVertexLabelDrawPaintFunction(Function<V, Paint> vertexLabelDrawPaintFunction) {
        this.vertexLabelDrawPaintFunction = vertexLabelDrawPaintFunction;
    }

    @Override
    public Function<V, Paint> getVertexLabelDrawPaintFunction() {
        return this.vertexLabelDrawPaintFunction;
    }

    @Override
    public GraphElementAccessor<V, E> getSelectionSupport() {
        return this.selectionSupport;
    }

    @Override
    public void setSelectionSupport(GraphElementAccessor<V, E> selectionSupport) {
        Objects.requireNonNull(selectionSupport);
        this.selectionSupport = selectionSupport;
    }

    @Override
    public MultiLayerTransformer getMultiLayerTransformer() {
        return this.multiLayerTransformer;
    }

    @Override
    public void setMultiLayerTransformer(MultiLayerTransformer basicTransformer) {
        this.multiLayerTransformer = basicTransformer;
    }

    @Override
    public Function<E, Paint> getArrowDrawPaintFunction() {
        return this.arrowDrawPaintFunction;
    }

    @Override
    public Function<E, Paint> getArrowFillPaintFunction() {
        return this.arrowFillPaintFunction;
    }

    @Override
    public void setArrowDrawPaintFunction(Function<E, Paint> arrowDrawPaintFunction) {
        this.arrowDrawPaintFunction = arrowDrawPaintFunction;
    }

    @Override
    public void setArrowFillPaintFunction(Function<E, Paint> arrowFillPaintFunction) {
        this.arrowFillPaintFunction = arrowFillPaintFunction;
    }

    private static Shape getVertexShape(String shape, int size) {
        switch (shape) {
            case "SQUARE": {
                return new Rectangle2D.Float((float)(-size) / 2.0f, (float)(-size) / 2.0f, size, size);
            }
        }
        return new Ellipse2D.Float((float)(-size) / 2.0f, (float)(-size) / 2.0f, size, size);
    }

    private Renderer.VertexLabel.Position getPosition(String position) {
        try {
            return Renderer.VertexLabel.Position.valueOf(position);
        }
        catch (Exception exception) {
            return Renderer.VertexLabel.Position.SE;
        }
    }

    private void setEdgeShape(String edgeShape) {
        switch (edgeShape) {
            case "LINE": {
                this.setEdgeShapeFunction(EdgeShape.line());
                break;
            }
            case "CUBIC_CURVE": {
                this.setEdgeShapeFunction(EdgeShape.cubicCurve());
                break;
            }
            case "WEDGE": {
                this.setEdgeShapeFunction(EdgeShape.wedge());
                break;
            }
            default: {
                this.setEdgeShapeFunction(EdgeShape.quadCurve());
            }
        }
    }

    private void setEdgeStroke(String edgeStroke, float width) {
        switch (edgeStroke) {
            case "DOTTED": {
                this.edgeStroke = new BasicStroke(width, 1, 1, 1.0f, dotting, 0.0f);
                break;
            }
            case "DASHED": {
                this.edgeStroke = new BasicStroke(width, 2, 2, 1.0f, dashing, 0.0f);
                break;
            }
            default: {
                this.edgeStroke = new BasicStroke(width);
            }
        }
    }

    static {
        PropertyLoader.load();
    }

    public static class ShapeFunctionSupplier<V>
    implements Supplier<Function<V, Shape>> {
        int vertexSize = Integer.getInteger("jungrapht.vertexSize", 20);
        String vertexShapeString = System.getProperty("jungrapht.vertexShape", "CIRCLE");

        @Override
        public Function<V, Shape> get() {
            Shape vertexShape = DefaultRenderContext.getVertexShape(this.vertexShapeString, this.vertexSize);
            return v -> vertexShape;
        }
    }
}

