/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.model.address.KeyRange;
import ghidra.util.LockHold;
import ghidra.util.database.AbstractDirectedLongKeyIterator;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBAnnotatedObjectFactory;
import ghidra.util.database.DBCachedDomainObjectAdapter;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStoreEntrySet;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBCachedObjectStoreFoundKeysValueCollection;
import ghidra.util.database.DBCachedObjectStoreKeySet;
import ghidra.util.database.DBCachedObjectStoreMap;
import ghidra.util.database.DBCachedObjectStoreValueCollection;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.DirectedLongKeyIterator;
import ghidra.util.database.DirectedRecordIterator;
import ghidra.util.database.FieldSpan;
import ghidra.util.database.KeySpan;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DBCachedObjectStore<T extends DBAnnotatedObject>
implements ErrorHandler {
    private static final Comparator<? super Long> KEY_COMPARATOR = Long::compare;
    protected final BoundedStuff<Long, Long> keys = new BoundedStuff<Long, Long>(){

        @Override
        Long fromRecord(DBRecord record) {
            if (record == null) {
                return null;
            }
            return record.getKey();
        }

        @Override
        Long fromObject(T value) {
            throw new AssertionError();
        }

        @Override
        Long getKey(Long of) {
            return of;
        }

        @Override
        Long getMax() {
            long max = DBCachedObjectStore.this.table.getMaxKey();
            if (max == Long.MIN_VALUE) {
                return null;
            }
            return max;
        }

        @Override
        Long get(long key) {
            throw new AssertionError();
        }

        @Override
        Long checkAndConvert(Object o) {
            if (!(o instanceof Long)) {
                return null;
            }
            return (Long)o;
        }

        @Override
        boolean typedContains(Long u) throws IOException {
            if (DBCachedObjectStore.this.cache.get(u.longValue()) != null) {
                return true;
            }
            return DBCachedObjectStore.this.table.hasRecord(u.longValue());
        }

        @Override
        T typedRemove(Long u) throws IOException {
            DBAnnotatedObject in = (DBAnnotatedObject)((Object)DBCachedObjectStore.this.objects.get(u));
            if (in == null) {
                return null;
            }
            DBCachedObjectStore.this.table.deleteRecord(u.longValue());
            DBCachedObjectStore.this.cache.delete(u.longValue());
            return (Object)in;
        }

        @Override
        DirectedIterator<Long> rawIterator(DirectedIterator.Direction direction, KeySpan keySpan) throws IOException {
            return DirectedLongKeyIterator.getIterator(DBCachedObjectStore.this.table, keySpan, direction);
        }

        @Override
        Long fromRaw(Long raw) {
            return raw;
        }
    };
    protected final BoundedStuff<T, DBRecord> objects = new BoundedStuff<T, DBRecord>(){

        @Override
        T fromRecord(DBRecord record) throws IOException {
            if (record == null) {
                return null;
            }
            DBAnnotatedObject cached = (DBAnnotatedObject)DBCachedObjectStore.this.cache.get(record);
            if (cached != null) {
                return (Object)cached;
            }
            Object found = DBCachedObjectStore.this.factory.create(DBCachedObjectStore.this, record);
            ((DBAnnotatedObject)((Object)found)).doRefresh(record);
            return found;
        }

        @Override
        T fromObject(T value) {
            return value;
        }

        @Override
        Long getKey(T of) {
            return of.getKey();
        }

        @Override
        T checkAndConvert(Object o) {
            if (!DBCachedObjectStore.this.objectType.isInstance(o)) {
                return null;
            }
            return (Object)((DBAnnotatedObject)((Object)DBCachedObjectStore.this.objectType.cast(o)));
        }

        @Override
        boolean typedContains(T u) throws IOException {
            DBAnnotatedObject in = (DBAnnotatedObject)((Object)DBCachedObjectStore.this.objects.get(u.getKey()));
            return u == in;
        }

        @Override
        T typedRemove(T u) throws IOException {
            long key = u.getKey();
            DBAnnotatedObject in = (DBAnnotatedObject)((Object)this.get(key));
            if (u != in) {
                return null;
            }
            DBCachedObjectStore.this.table.deleteRecord(key);
            DBCachedObjectStore.this.cache.delete(key);
            return (Object)in;
        }

        @Override
        DirectedIterator<DBRecord> rawIterator(DirectedIterator.Direction direction, KeySpan keySpan) throws IOException {
            return DirectedRecordIterator.getIterator(DBCachedObjectStore.this.table, keySpan, direction);
        }

        @Override
        T fromRaw(DBRecord raw) throws IOException {
            return this.fromRecord(raw);
        }
    };
    protected final BoundedStuff<Map.Entry<Long, T>, DBRecord> entries = new BoundedStuff<Map.Entry<Long, T>, DBRecord>(){

        @Override
        Map.Entry<Long, T> fromRecord(DBRecord record) throws IOException {
            if (record == null) {
                return null;
            }
            return ImmutablePair.of((Object)record.getKey(), (Object)((Object)((DBAnnotatedObject)((Object)DBCachedObjectStore.this.objects.fromRecord(record)))));
        }

        @Override
        Map.Entry<Long, T> fromObject(T value) {
            return ImmutablePair.of((Object)value.getKey(), value);
        }

        @Override
        Long getKey(Map.Entry<Long, T> of) {
            return of.getKey();
        }

        @Override
        Map.Entry<Long, T> checkAndConvert(Object o) {
            if (!(o instanceof Map.Entry)) {
                return null;
            }
            Map.Entry ent = (Map.Entry)o;
            Object ko = ent.getKey();
            if (!(ko instanceof Long)) {
                return null;
            }
            DBAnnotatedObject val = (DBAnnotatedObject)((Object)DBCachedObjectStore.this.objects.checkAndConvert(ent.getValue()));
            if (val == null) {
                return null;
            }
            return ent;
        }

        @Override
        boolean typedContains(Map.Entry<Long, T> u) throws IOException {
            if (u.getKey().longValue() != ((DBAnnotatedObject)((Object)u.getValue())).getKey()) {
                return false;
            }
            return DBCachedObjectStore.this.objects.typedContains((DBAnnotatedObject)((Object)u.getValue()));
        }

        @Override
        T typedRemove(Map.Entry<Long, T> u) throws IOException {
            if (u.getKey().longValue() != ((DBAnnotatedObject)((Object)u.getValue())).getKey()) {
                return null;
            }
            return DBCachedObjectStore.this.objects.typedRemove((DBAnnotatedObject)((Object)u.getValue()));
        }

        @Override
        DirectedIterator<DBRecord> rawIterator(DirectedIterator.Direction direction, KeySpan keySpan) throws IOException {
            return DirectedRecordIterator.getIterator(DBCachedObjectStore.this.table, keySpan, direction);
        }

        @Override
        Map.Entry<Long, T> fromRaw(DBRecord raw) throws IOException {
            return this.fromRecord(raw);
        }
    };
    final DBCachedDomainObjectAdapter adapter;
    final DBHandle dbh;
    final DBObjectCache<T> cache;
    private final Class<T> objectType;
    private final DBAnnotatedObjectFactory<T> factory;
    private final String tableName;
    private final Schema schema;
    private final ReadWriteLock lock;
    protected final DBCachedObjectStoreMap<T> asForwardMap;
    protected final DBCachedObjectStoreKeySet asForwardKeySet;
    protected final DBCachedObjectStoreValueCollection<T> asForwardValueCollection;
    protected final DBCachedObjectStoreEntrySet<T> asForwardEntrySet;
    protected final List<DBCachedObjectStoreFactory.DBFieldCodec<?, T, ?>> codecs;
    Table table;

    protected DBCachedObjectStore(DBCachedDomainObjectAdapter adapter, Class<T> objectType, DBAnnotatedObjectFactory<T> factory, Table table) {
        this.adapter = adapter;
        this.dbh = adapter.getDBHandle();
        this.objectType = objectType;
        this.factory = factory;
        this.table = table;
        this.tableName = table.getName();
        this.schema = table.getSchema();
        this.cache = new DBObjectCache(1000);
        this.lock = adapter.getReadWriteLock();
        this.codecs = DBCachedObjectStoreFactory.getCodecs(objectType);
        this.asForwardMap = new DBCachedObjectStoreMap(this, (ErrorHandler)adapter, this.lock, DirectedIterator.Direction.FORWARD);
        this.asForwardKeySet = new DBCachedObjectStoreKeySet(this, (ErrorHandler)adapter, this.lock, DirectedIterator.Direction.FORWARD);
        this.asForwardValueCollection = new DBCachedObjectStoreValueCollection(this, (ErrorHandler)adapter, this.lock, DirectedIterator.Direction.FORWARD);
        this.asForwardEntrySet = new DBCachedObjectStoreEntrySet(this, (ErrorHandler)adapter, this.lock, DirectedIterator.Direction.FORWARD);
    }

    public int getRecordCount() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            int n = this.table.getRecordCount();
            return n;
        }
    }

    public Long getMaxKey() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            long max = this.table.getMaxKey();
            if (max == Long.MIN_VALUE) {
                Long l = null;
                return l;
            }
            Long l = max;
            return l;
        }
    }

    protected int getKeyCount(KeySpan keySpan) {
        if (keySpan.isEmpty()) {
            return 0;
        }
        int i = 0;
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            if (KeySpan.ALL.equals(keySpan)) {
                throw new AssertionError();
            }
            AbstractDirectedLongKeyIterator it = DirectedLongKeyIterator.getIterator(this.table, keySpan, DirectedIterator.Direction.FORWARD);
            while (it.hasNext()) {
                it.next();
                ++i;
            }
        }
        catch (IOException e) {
            this.adapter.dbError(e);
        }
        return i;
    }

    protected boolean getKeysExist(KeySpan keySpan) {
        if (keySpan.isEmpty()) {
            return false;
        }
        LockHold hold = LockHold.lock(this.lock.readLock());
        try {
            boolean bl;
            if (KeySpan.ALL.equals(keySpan)) {
                throw new AssertionError();
            }
            DBRecord rec = this.table.getRecordAtOrAfter(((Long)keySpan.min()).longValue());
            boolean bl2 = bl = rec != null && keySpan.contains(rec.getKey());
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.adapter.dbError(e);
                return false;
            }
        }
    }

    public boolean containsKey(long key) {
        LockHold hold = LockHold.lock(this.lock.readLock());
        try {
            boolean bl = this.keys.typedContains(key);
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.adapter.dbError(e);
                return false;
            }
        }
    }

    public boolean contains(T obj) {
        LockHold hold = LockHold.lock(this.lock.readLock());
        try {
            boolean bl = this.objects.typedContains(obj);
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.adapter.dbError(e);
                return false;
            }
        }
    }

    protected T doCreate(long key) throws IOException {
        DBRecord rec = this.schema.createRecord(key);
        this.table.putRecord(rec);
        T created = this.factory.create(this, rec);
        ((DBAnnotatedObject)((Object)created)).fresh(true);
        ((DBAnnotatedObject)((Object)created)).doUpdateAll();
        return created;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T create(long key) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            T t = this.doCreate(key);
            return t;
        }
        catch (IOException e) {
            this.adapter.dbError(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T create() {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            T t = this.doCreate(this.table.getKey());
            return t;
        }
        catch (IOException e) {
            this.adapter.dbError(e);
            return null;
        }
    }

    protected int getColumnByName(String name) {
        int index = ArrayUtils.indexOf((Object[])this.schema.getFieldNames(), (Object)name);
        if (index < 0) {
            throw new NoSuchElementException(name);
        }
        return index;
    }

    protected <K> DBCachedObjectIndex<K, T> getIndex(Class<K> fieldClass, int columnIndex) {
        if (!ArrayUtils.contains((int[])this.table.getIndexedColumns(), (int)columnIndex)) {
            throw new IllegalArgumentException("Column " + this.schema.getFieldNames()[columnIndex] + " is not indexed");
        }
        DBCachedObjectStoreFactory.DBFieldCodec<?, T, ?> codec = this.codecs.get(columnIndex);
        Class<?> exp = codec.getValueType();
        if (fieldClass != exp) {
            throw new IllegalArgumentException("Column " + this.schema.getFieldNames()[columnIndex] + " is not of type " + String.valueOf(fieldClass) + "! It is " + String.valueOf(exp));
        }
        DBCachedObjectStoreFactory.DBFieldCodec<?, T, ?> castCodec = codec;
        return new DBCachedObjectIndex(this, (ErrorHandler)this.adapter, castCodec, columnIndex, FieldSpan.ALL, DirectedIterator.Direction.FORWARD);
    }

    public <K> DBCachedObjectIndex<K, T> getIndex(Class<K> fieldClass, DBObjectColumn column) {
        return this.getIndex(fieldClass, column.columnNumber);
    }

    public <K> DBCachedObjectIndex<K, T> getIndex(Class<K> fieldClass, String columnName) {
        int columnIndex = this.getColumnByName(columnName);
        return this.getIndex(fieldClass, columnIndex);
    }

    public boolean delete(T obj) {
        LockHold hold = LockHold.lock(this.lock.writeLock());
        try {
            boolean bl;
            boolean bl2 = bl = this.objects.typedRemove(obj) != null;
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.adapter.dbError(e);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deleteKey(long key) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            Object t = this.keys.typedRemove(key);
            return t;
        }
        catch (IOException e) {
            this.adapter.dbError(e);
            return null;
        }
    }

    public void deleteAll() {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            this.table.deleteAll();
            this.cache.invalidate();
        }
        catch (IOException e) {
            this.adapter.dbError(e);
        }
    }

    protected void deleteKeys(KeySpan keySpan) {
        if (keySpan.isEmpty()) {
            return;
        }
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            long min = (Long)keySpan.min();
            long max = (Long)keySpan.max();
            this.table.deleteRecords(min, max);
            this.cache.delete(List.of(new KeyRange(min, max)));
        }
        catch (IOException e) {
            this.adapter.dbError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <U> U safe(Lock l, SupplierAllowsIOException<U> supplier) {
        try (LockHold hold = LockHold.lock(l);){
            U u = supplier.get();
            return u;
        }
        catch (IOException e) {
            this.adapter.dbError(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getObjectAt(long key) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            DBAnnotatedObject dBAnnotatedObject = (DBAnnotatedObject)((Object)this.objects.get(key));
            return (T)((Object)dBAnnotatedObject);
        }
        catch (IOException e) {
            this.adapter.dbError(e);
            return null;
        }
    }

    protected Comparator<? super Long> keyComparator() {
        return KEY_COMPARATOR;
    }

    public DBCachedObjectStoreMap<T> asMap() {
        return this.asForwardMap;
    }

    protected T findOneObject(int columnIndex, Field field) throws IOException {
        Field[] found = this.table.findRecords(field, columnIndex);
        if (found.length == 0) {
            return null;
        }
        if (found.length != 1) {
            throw new IllegalStateException("More than one match");
        }
        return this.getObjectAt(found[0].getLongValue());
    }

    protected DBCachedObjectStoreFoundKeysValueCollection<T> findObjects(int columnIndex, Field field) throws IOException {
        Field[] found = this.table.findRecords(field, columnIndex);
        return new DBCachedObjectStoreFoundKeysValueCollection(this, (ErrorHandler)this.adapter, this.lock, found);
    }

    protected Iterator<T> iterator(int columnIndex, FieldSpan fieldSpan, DirectedIterator.Direction direction) throws IOException {
        DirectedRecordIterator it = DirectedRecordIterator.getIndexIterator(this.table, columnIndex, fieldSpan, direction);
        return this.objects.iterator(it);
    }

    boolean isCached(long key) {
        return this.cache.get(key) != null;
    }

    public Lock readLock() {
        return this.lock.readLock();
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void dbError(IOException e) {
        this.adapter.dbError(e);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DBCachedObjectStore of " + String.valueOf(this.objectType) + ". Cache: ");
        builder.append(StringUtils.join((Iterable)this.cache.getCachedObjects(), (String)", "));
        return builder.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void invalidateCache() {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            this.cache.invalidate();
            this.table = this.dbh.getTable(this.tableName);
            assert (this.schema.equals((Object)this.table.getSchema()));
        }
    }

    protected abstract class BoundedStuff<E, R> {
        protected BoundedStuff() {
        }

        abstract E fromRecord(DBRecord var1) throws IOException;

        abstract E fromObject(T var1);

        abstract Long getKey(E var1);

        abstract E checkAndConvert(Object var1);

        abstract boolean typedContains(E var1) throws IOException;

        abstract T typedRemove(E var1) throws IOException;

        abstract DirectedIterator<R> rawIterator(DirectedIterator.Direction var1, KeySpan var2) throws IOException;

        abstract E fromRaw(R var1) throws IOException;

        E filter(E candidate, KeySpan keySpan) {
            if (candidate == null || !keySpan.contains(this.getKey(candidate))) {
                return null;
            }
            return candidate;
        }

        E getMax() throws IOException {
            long max = DBCachedObjectStore.this.table.getMaxKey();
            if (max == Long.MIN_VALUE) {
                return null;
            }
            return this.get(max);
        }

        E getBefore(long key) throws IOException {
            return this.fromRecord(DBCachedObjectStore.this.table.getRecordBefore(key));
        }

        E getBefore(long key, KeySpan keySpan) throws IOException {
            if (KeySpan.DOMAIN.min() == key) {
                return null;
            }
            long max = (Long)KeySpan.DOMAIN.min((Long)keySpan.max(), KeySpan.DOMAIN.dec(key));
            return this.filter(this.getAtOrBefore(max), keySpan);
        }

        E getAtOrBefore(long key) throws IOException {
            return this.fromRecord(DBCachedObjectStore.this.table.getRecordAtOrBefore(key));
        }

        E getAtOrBefore(long key, KeySpan keySpan) throws IOException {
            long max = (Long)KeySpan.DOMAIN.min((Long)keySpan.max(), key);
            return this.filter(this.getAtOrBefore(max), keySpan);
        }

        E get(long key) throws IOException {
            DBAnnotatedObject cached = (DBAnnotatedObject)DBCachedObjectStore.this.cache.get(key);
            if (cached != null) {
                return this.fromObject(cached);
            }
            return this.fromRecord(DBCachedObjectStore.this.table.getRecord(key));
        }

        E getAtOrAfter(long key) throws IOException {
            return this.fromRecord(DBCachedObjectStore.this.table.getRecordAtOrAfter(key));
        }

        E getAtOrAfter(long key, KeySpan keySpan) throws IOException {
            long min = (Long)KeySpan.DOMAIN.max((Long)keySpan.min(), key);
            return this.filter(this.getAtOrAfter(min), keySpan);
        }

        E getAfter(long key) throws IOException {
            return this.fromRecord(DBCachedObjectStore.this.table.getRecordAfter(key));
        }

        E getAfter(long key, KeySpan keySpan) throws IOException {
            if (KeySpan.DOMAIN.max() == key) {
                return null;
            }
            long min = (Long)KeySpan.DOMAIN.max((Long)keySpan.min(), KeySpan.DOMAIN.inc(key));
            return this.filter(this.getAtOrAfter(min), keySpan);
        }

        boolean contains(Object o) throws IOException {
            E u = this.checkAndConvert(o);
            if (u == null) {
                return false;
            }
            return this.typedContains(u);
        }

        boolean contains(Object o, KeySpan keySpan) throws IOException {
            E u = this.checkAndConvert(o);
            if (u == null) {
                return false;
            }
            if (!keySpan.contains(this.getKey(u))) {
                return false;
            }
            return this.typedContains(u);
        }

        boolean containsAll(Collection<?> c) throws IOException {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        boolean containsAll(Collection<?> c, KeySpan keySpan) throws IOException {
            for (Object o : c) {
                if (this.contains(o, keySpan)) continue;
                return false;
            }
            return true;
        }

        boolean remove(Object o) throws IOException {
            E u = this.checkAndConvert(o);
            if (u == null) {
                return false;
            }
            return this.typedRemove(u) != null;
        }

        boolean remove(Object o, KeySpan keySpan) throws IOException {
            E u = this.checkAndConvert(o);
            if (u == null) {
                return false;
            }
            if (!keySpan.contains(this.getKey(u))) {
                return false;
            }
            return this.typedRemove(u) != null;
        }

        boolean removeAll(Collection<?> c) throws IOException {
            boolean result = false;
            for (Object o : c) {
                result |= this.remove(o);
            }
            return result;
        }

        boolean removeAll(Collection<?> c, KeySpan keySpan) throws IOException {
            boolean result = false;
            for (Object o : c) {
                result |= this.remove(o, keySpan);
            }
            return result;
        }

        E first() throws IOException {
            return this.getAtOrAfter(Long.MIN_VALUE);
        }

        E first(KeySpan keySpan) throws IOException {
            return this.filter(this.getAtOrAfter((Long)keySpan.min()), keySpan);
        }

        E first(DirectedIterator.Direction direction) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.first();
            }
            return this.last();
        }

        E first(DirectedIterator.Direction direction, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.first(keySpan);
            }
            return this.last(keySpan);
        }

        E last() throws IOException {
            return this.getMax();
        }

        E last(KeySpan keySpan) throws IOException {
            return this.filter(this.getAtOrBefore((Long)keySpan.max()), keySpan);
        }

        E last(DirectedIterator.Direction direction) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.last();
            }
            return this.first();
        }

        E last(DirectedIterator.Direction direction, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.last(keySpan);
            }
            return this.first(keySpan);
        }

        E lower(DirectedIterator.Direction direction, long key) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getBefore(key);
            }
            return this.getAfter(key);
        }

        E lower(DirectedIterator.Direction direction, long key, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getBefore(key, keySpan);
            }
            return this.getAfter(key, keySpan);
        }

        E floor(DirectedIterator.Direction direction, long key) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAtOrBefore(key);
            }
            return this.getAtOrAfter(key);
        }

        E floor(DirectedIterator.Direction direction, long key, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAtOrBefore(key, keySpan);
            }
            return this.getAtOrAfter(key, keySpan);
        }

        E ceiling(DirectedIterator.Direction direction, long key) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAtOrAfter(key);
            }
            return this.getAtOrBefore(key);
        }

        E ceiling(DirectedIterator.Direction direction, long key, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAtOrAfter(key, keySpan);
            }
            return this.getAtOrBefore(key, keySpan);
        }

        E higher(DirectedIterator.Direction direction, long key) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAfter(key);
            }
            return this.getBefore(key);
        }

        E higher(DirectedIterator.Direction direction, long key, KeySpan keySpan) throws IOException {
            if (direction == DirectedIterator.Direction.FORWARD) {
                return this.getAfter(key, keySpan);
            }
            return this.getBefore(key, keySpan);
        }

        Iterator<E> iterator(final DirectedIterator<R> it) {
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.readLock());
                    try {
                        boolean bl = it.hasNext();
                        if (hold != null) {
                            hold.close();
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (hold != null) {
                                try {
                                    hold.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            DBCachedObjectStore.this.adapter.dbError(e);
                            return false;
                        }
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public E next() {
                    try (LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.readLock());){
                        Object e = BoundedStuff.this.fromRaw(it.next());
                        return e;
                    }
                    catch (IOException e2) {
                        DBCachedObjectStore.this.adapter.dbError(e2);
                        return null;
                    }
                }

                @Override
                public void remove() {
                    try (LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.writeLock());){
                        it.delete();
                    }
                    catch (IOException e) {
                        DBCachedObjectStore.this.adapter.dbError(e);
                    }
                }
            };
        }

        Iterator<E> iterator(DirectedIterator.Direction direction, KeySpan keySpan) {
            if (keySpan != null && keySpan.isEmpty()) {
                return Collections.emptyIterator();
            }
            LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.readLock());
            try {
                Iterator<E> iterator = this.iterator(this.rawIterator(direction, keySpan));
                if (hold != null) {
                    hold.close();
                }
                return iterator;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    DBCachedObjectStore.this.adapter.dbError(e);
                    return null;
                }
            }
        }

        void intoArray(E[] arr, DirectedIterator.Direction direction, KeySpan keySpan) {
            if (keySpan != null && keySpan.isEmpty()) {
                return;
            }
            try (LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.readLock());){
                DirectedIterator<R> it = this.rawIterator(direction, keySpan);
                int i = 0;
                while (it.hasNext()) {
                    arr[i] = this.fromRaw(it.next());
                    ++i;
                }
            }
            catch (IOException e) {
                DBCachedObjectStore.this.adapter.dbError(e);
            }
        }

        void toList(List<? super E> list, DirectedIterator.Direction direction, KeySpan keySpan) {
            if (keySpan != null && keySpan.isEmpty()) {
                return;
            }
            try (LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.readLock());){
                DirectedIterator<R> it = this.rawIterator(direction, keySpan);
                while (it.hasNext()) {
                    list.add(this.fromRaw(it.next()));
                }
            }
            catch (IOException e) {
                DBCachedObjectStore.this.adapter.dbError(e);
            }
        }

        Object[] toArray(DirectedIterator.Direction direction, KeySpan keySpan) {
            ArrayList list = new ArrayList();
            this.toList(list, direction, keySpan);
            return list.toArray();
        }

        public <W> W[] toArray(DirectedIterator.Direction direction, KeySpan keySpan, W[] a, int size) {
            if (a.length < size) {
                ArrayList list = new ArrayList();
                this.toList(list, direction, keySpan);
                return list.toArray(a);
            }
            this.intoArray(a, direction, keySpan);
            for (int i = size; i < a.length; ++i) {
                a[i] = null;
            }
            return a;
        }

        boolean retain(Collection<?> c, KeySpan keySpan) {
            if (keySpan != null && keySpan.isEmpty()) {
                return false;
            }
            boolean result = false;
            try (LockHold hold = LockHold.lock(DBCachedObjectStore.this.lock.writeLock());){
                DirectedIterator<R> it = this.rawIterator(DirectedIterator.Direction.FORWARD, keySpan);
                while (it.hasNext()) {
                    E u = this.fromRaw(it.next());
                    if (c.contains(u)) continue;
                    it.delete();
                    DBCachedObjectStore.this.cache.delete(this.getKey(u).longValue());
                    result = true;
                }
            }
            catch (IOException e) {
                DBCachedObjectStore.this.adapter.dbError(e);
            }
            return result;
        }
    }

    protected static interface SupplierAllowsIOException<U> {
        public U get() throws IOException;
    }
}

