/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.ProcessorNotFoundException;
import java.util.HashMap;

public class Processor
implements Comparable<Processor> {
    private static HashMap<String, Processor> instances = null;
    private final String name;
    private static RegisterHook registerHook = null;

    private static synchronized void initialize() {
        if (instances == null) {
            instances = new HashMap();
        }
    }

    public static synchronized Processor findOrPossiblyCreateProcessor(String name) {
        Processor.initialize();
        if (!instances.containsKey(name)) {
            Processor.register(name);
        }
        return instances.get(name);
    }

    public static synchronized Processor toProcessor(String name) {
        Processor.initialize();
        Processor processor = instances.get(name);
        if (processor == null) {
            throw new ProcessorNotFoundException(name);
        }
        return processor;
    }

    private Processor(String name) {
        this.name = name;
    }

    private static synchronized Processor register(String name) {
        Processor.initialize();
        if (registerHook != null) {
            registerHook.register(name);
        }
        Processor p = new Processor(name);
        instances.put(name, p);
        return p;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Processor other = (Processor)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(Processor p) {
        if (p == null) {
            return -1;
        }
        String thisStr = this.toString();
        String otherStr = p.toString();
        return thisStr.compareToIgnoreCase(otherStr);
    }

    static interface RegisterHook {
        public void register(String var1);
    }
}

