/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;

public class DefinedStringIterator
implements DataIterator {
    private Deque<DataIterator> itStack = new ArrayDeque<DataIterator>();
    private Data currentDataResult;
    private int dataCandidateCount;

    public static DefinedStringIterator forProgram(Program program) {
        return new DefinedStringIterator(program, null);
    }

    public static DefinedStringIterator forProgram(Program program, AddressSetView addrs) {
        return new DefinedStringIterator(program, addrs);
    }

    public static DefinedStringIterator forDataInstance(Data singleDataInstance) {
        return new DefinedStringIterator(singleDataInstance);
    }

    private DefinedStringIterator(Program program, AddressSetView addrs) {
        this.itStack.addLast(program.getListing().getDefinedData(addrs == null ? program.getMemory().getAllInitializedAddressSet() : addrs, true));
    }

    private DefinedStringIterator(Data singleDataInstance) {
        this.itStack.addLast(DataIterator.of(singleDataInstance));
    }

    @Override
    public boolean hasNext() {
        this.updateNextResultIfNeeded();
        return this.currentDataResult != null;
    }

    @Override
    public Data next() {
        this.updateNextResultIfNeeded();
        if (this.currentDataResult == null) {
            throw new NoSuchElementException();
        }
        Data result = this.currentDataResult;
        this.currentDataResult = null;
        return result;
    }

    public int getDataCandidateCount() {
        return this.dataCandidateCount;
    }

    private DataIterator currentIt() {
        DataIterator it = null;
        while ((it = this.itStack.peekLast()) != null && !it.hasNext()) {
            this.itStack.removeLast();
        }
        return it;
    }

    private void updateNextResultIfNeeded() {
        DataIterator it = null;
        while (this.currentDataResult == null && (it = this.currentIt()) != null) {
            Composite comp;
            ++this.dataCandidateCount;
            Data data = it.next();
            DataType dt = data.getBaseDataType();
            if (StringDataInstance.isString(data)) {
                this.currentDataResult = data;
                return;
            }
            if (dt instanceof Array) {
                Array arrayDT = (Array)dt;
                DataType elementDT = arrayDT.getDataType();
                if (!this.containsStringDataType(elementDT)) continue;
                this.itStack.addLast(new DataComponentIterator(data));
                continue;
            }
            if (!(dt instanceof Composite) || !this.containsStringDataType(comp = (Composite)dt)) continue;
            this.itStack.addLast(comp instanceof Structure ? new StructDtcIterator(data, comp) : new DataComponentIterator(data));
        }
    }

    private boolean containsStringDataType(DataType dt) {
        if (StringDataInstance.isStringDataType(dt)) {
            return true;
        }
        if (dt instanceof Array) {
            Array arrayDT = (Array)dt;
            DataType elementDT = arrayDT.getDataType();
            return arrayDT.getNumElements() != 0 && this.containsStringDataType(elementDT);
        }
        if (dt instanceof Structure) {
            Structure struct = (Structure)dt;
            for (DataTypeComponent dtc : struct.getDefinedComponents()) {
                if (dtc.getLength() == 0 || !this.containsStringDataType(dtc.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dt instanceof Composite) {
            Composite comp = (Composite)dt;
            for (DataTypeComponent dtc : comp.getComponents()) {
                if (!this.containsStringDataType(dtc.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dt instanceof TypeDef) {
            TypeDef tdDT = (TypeDef)dt;
            return this.containsStringDataType(tdDT.getBaseDataType());
        }
        return false;
    }

    private static class DataComponentIterator
    implements DataIterator {
        private Data data;
        private int currentIndex;
        private int elementCount;

        public DataComponentIterator(Data data) {
            this.data = data;
            this.elementCount = data.getNumComponents();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.elementCount;
        }

        @Override
        public Data next() {
            Data result = this.data.getComponent(this.currentIndex);
            ++this.currentIndex;
            return result;
        }
    }

    private static class StructDtcIterator
    implements DataIterator {
        private Data data;
        private int currentIndex = -1;
        private DataTypeComponent[] dtcs;

        public StructDtcIterator(Data data, Composite compDT) {
            this.data = data;
            this.dtcs = compDT.getDefinedComponents();
            this.advanceToNextGoodDtcIndex();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.dtcs.length;
        }

        private void advanceToNextGoodDtcIndex() {
            ++this.currentIndex;
            while (this.currentIndex < this.dtcs.length && (this.dtcs[this.currentIndex].getLength() == 0 || this.dtcs[this.currentIndex].isBitFieldComponent() || this.data.getComponentContaining(this.dtcs[this.currentIndex].getOffset()) == null)) {
                ++this.currentIndex;
            }
        }

        @Override
        public Data next() {
            Data result = this.data.getComponentContaining(this.dtcs[this.currentIndex].getOffset());
            this.advanceToNextGoodDtcIndex();
            return result;
        }
    }
}

