/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.app.plugin.core.stackeditor.StackEditorOptionManager;
import ghidra.app.plugin.core.stackeditor.StackEditorProvider;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StackEditorModel
extends CompositeEditorModel<StackFrameDataType> {
    private static final long serialVersionUID = 1L;
    public static final int OFFSET = 0;
    public static final int LENGTH = 1;
    public static final int DATATYPE = 2;
    public static final int NAME = 3;
    public static final int COMMENT = 4;
    private static final int MAX_LOCAL_SIZE = Integer.MAX_VALUE;
    private static final int MAX_PARAM_SIZE = Integer.MAX_VALUE;
    private Function function;
    private StackFrameDataType originalStackFrameDataType;
    private boolean stackChangedExternally;

    StackEditorModel(StackEditorProvider provider) {
        super(provider);
        this.headers = new String[]{"Offset", "Length", "DataType", "Name", "Comment"};
        this.columnWidths = new int[]{40, 40, 100, 100, 150};
        this.columnOffsets = new int[this.headers.length];
        this.adjustOffsets();
        Plugin plugin = provider.getPlugin();
        this.showHexNumbers = plugin instanceof StackEditorOptionManager ? ((StackEditorOptionManager)plugin).showStackNumbersInHex() : true;
    }

    @Override
    public String getTypeName() {
        return "Stack";
    }

    @Override
    protected boolean allowsZeroLengthComponents() {
        return false;
    }

    @Override
    protected boolean allowsBitFields() {
        return false;
    }

    @Override
    protected boolean usesAlignedLengthComponents() {
        return false;
    }

    void stackChangedExternally(boolean changed) {
        this.stackChangedExternally = changed;
        if (changed) {
            this.setStatus("Stack may have been changed externally -- data may be stale.");
        }
    }

    @Override
    void load(Function func) {
        this.function = func;
        this.originalStackFrameDataType = new StackFrameDataType(this.function);
        this.load(this.originalStackFrameDataType);
    }

    @Override
    public void load(StackFrameDataType dataType) {
        this.stackChangedExternally(false);
        super.load(dataType);
    }

    @Override
    protected void createViewCompositeFromOriginalComposite() {
        if (this.viewDTM != null) {
            this.viewDTM.close();
            this.viewDTM = null;
        }
        this.viewDTM = new CompositeViewerDataTypeManager(this.originalDTM.getName(), this.originalDTM);
        this.viewComposite = ((StackFrameDataType)this.originalComposite).copy(this.originalDTM);
        ((StackFrameDataType)this.originalComposite).resolveWrappedComposite(this.viewDTM);
        this.originalComposite = this.originalStackFrameDataType;
    }

    @Override
    protected void restoreEditor() {
        throw new UnsupportedOperationException("undo/redo not supported");
    }

    @Override
    public boolean updateAndCheckChangeState() {
        StackFrameDataType sfdt = (StackFrameDataType)this.viewComposite;
        int editReturnAddressOffset = sfdt.getReturnAddressOffset();
        int editLocalSize = sfdt.getLocalSize();
        int editParamOffset = sfdt.getParameterOffset();
        int editParamSize = sfdt.getParameterSize();
        int stackReturnAddressOffset = this.originalStackFrameDataType.getReturnAddressOffset();
        int stackLocalSize = this.originalStackFrameDataType.getLocalSize();
        int stackParamOffset = this.originalStackFrameDataType.getParameterOffset();
        int stackParamSize = this.originalStackFrameDataType.getParameterSize();
        this.hasChanges = editReturnAddressOffset != stackReturnAddressOffset || editLocalSize != stackLocalSize || editParamOffset != stackParamOffset || editParamSize != stackParamSize || super.updateAndCheckChangeState();
        return this.hasChanges;
    }

    @Override
    public int getOffsetColumn() {
        return 0;
    }

    @Override
    public int getLengthColumn() {
        return 1;
    }

    @Override
    public int getMnemonicColumn() {
        return -1;
    }

    @Override
    public int getDataTypeColumn() {
        return 2;
    }

    @Override
    public int getNameColumn() {
        return 3;
    }

    @Override
    public int getCommentColumn() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.viewComposite == null || rowIndex >= ((StackFrameDataType)this.viewComposite).getNumComponents() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return "";
        }
        StackFrameDataType.StackComponentWrapper element = ((StackFrameDataType)this.viewComposite).getComponent(rowIndex);
        switch (columnIndex) {
            case 0: {
                int offset = ((StackFrameDataType)this.viewComposite).getComponent(rowIndex).getOffset();
                return this.showHexNumbers ? StackEditorModel.getHexString(offset, true) : Integer.toString(offset);
            }
            case 1: {
                String compHexLen;
                DataType dt = element.getDataType();
                int dtLen = dt.getLength();
                String dtHexLen = this.showHexNumbers ? StackEditorModel.getHexString(dtLen, true) : Integer.toString(dtLen);
                int compLen = element.getLength();
                String string = compHexLen = this.showHexNumbers ? StackEditorModel.getHexString(compLen, true) : Integer.toString(compLen);
                if (dtLen >= 0 && dtLen != compLen) {
                    return compHexLen + " (needs " + dtHexLen + ")";
                }
                return compHexLen;
            }
            case 2: {
                DataType dt = element.getDataType();
                int dtLen = dt.getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : element.getLength()), (boolean)this.usesAlignedLengthComponents());
            }
            case 3: {
                String fieldName = this.getFieldNameAtRow(rowIndex, (StackFrameDataType)this.viewComposite);
                if (fieldName == null) {
                    fieldName = "";
                }
                return fieldName;
            }
            case 4: {
                return element.getComment();
            }
        }
        return null;
    }

    private String getFieldNameAtRow(int rowIndex, StackFrameDataType stackDt) {
        StackFrameDataType.StackComponentWrapper stackDtc = stackDt.getComponent(rowIndex);
        String fieldName = stackDtc.getFieldName();
        if (fieldName == null && stackDt.isStackVariable(rowIndex)) {
            fieldName = stackDt.getDefaultName(stackDtc);
        }
        return fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int modelColumnIndex) {
        try {
            this.settingValueAt = true;
            Object originalValue = this.getValueAt(rowIndex, modelColumnIndex);
            if (SystemUtilities.isEqual((Object)originalValue, (Object)aValue)) {
                return;
            }
            this.fieldEdited(aValue, rowIndex, modelColumnIndex);
            this.setSelection(new int[]{rowIndex});
        }
        finally {
            this.settingValueAt = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fieldEdited(Object value, int rowIndex, int columnIndex) {
        if (this.applyingFieldEdit) {
            return true;
        }
        try {
            this.applyingFieldEdit = true;
            switch (columnIndex) {
                case 0: {
                    this.setComponentOffset(rowIndex, (String)value);
                    break;
                }
                case 2: {
                    this.setComponentDataType(rowIndex, value);
                    break;
                }
                case 3: {
                    this.setComponentName(rowIndex, ((String)value).trim());
                    break;
                }
                case 4: {
                    this.setComponentComment(rowIndex, (String)value);
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            this.clearStatus();
            boolean bl = true;
            return bl;
        }
        catch (UsrException e) {
            this.setStatus(e.getMessage(), true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.applyingFieldEdit = false;
        }
    }

    @Override
    public void validateComponentOffset(int index, String offset) throws UsrException {
        try {
            StackFrameDataType.StackComponentWrapper existing;
            int newOffset = Integer.decode(offset);
            StackFrameDataType sfdt = (StackFrameDataType)this.viewComposite;
            if (newOffset < sfdt.getMinOffset() || newOffset > sfdt.getMaxOffset()) {
                throw new UsrException(offset + " is not an offset in this stack frame.");
            }
            StackFrameDataType.StackComponentWrapper comp = this.getComponent(index);
            int oldOffset = comp.getOffset();
            int compLength = comp.getLength();
            int start = newOffset;
            int checkLength = compLength;
            if (newOffset == oldOffset) {
                return;
            }
            if (newOffset < oldOffset) {
                if (newOffset + compLength > oldOffset) {
                    checkLength = oldOffset - newOffset;
                }
            } else if (newOffset < oldOffset + compLength) {
                start = oldOffset + compLength;
                checkLength = newOffset - oldOffset;
            }
            if ((existing = sfdt.getComponentAt(start)) == null) {
                if (start + compLength > sfdt.getMaxOffset()) {
                    throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit in the stack frame when placed at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
                }
                throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
            }
            if (sfdt.isStackVariable(existing.getOrdinal())) {
                throw new InvalidInputException("There is already a stack variable at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
            }
            int unavailable = newOffset - existing.getOffset();
            int mrl = sfdt.getMaxLength(newOffset) - unavailable;
            if (mrl != -1 && checkLength > mrl) {
                int available = mrl + (compLength - checkLength);
                throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit at offset " + StackEditorModel.getHexString(newOffset, true) + ". It needs " + compLength + " bytes, but " + available + " bytes are available.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new UsrException("\"" + offset + "\" is not a valid offset.");
        }
    }

    public void setComponentOffset(int rowIndex, String value) throws UsrException {
        int svOffset;
        StackFrameDataType.StackComponentWrapper element = ((StackFrameDataType)this.viewComposite).getComponent(rowIndex);
        int offset = element.getOffset();
        if (offset == (svOffset = Integer.decode(value).intValue())) {
            return;
        }
        StackFrameDataType.StackComponentWrapper newElement = ((StackFrameDataType)this.viewComposite).setOffset(rowIndex, svOffset);
        this.setSelection(new int[]{newElement.getOrdinal()});
        this.notifyCompositeChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getNumSelectedRows() > 1) {
            return false;
        }
        if (columnIndex == 1) {
            return false;
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return false;
        }
        StackFrameDataType.StackComponentWrapper dtc = ((StackFrameDataType)this.viewComposite).getComponent(rowIndex);
        if (dtc == null) {
            return false;
        }
        boolean notDefined = ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(rowIndex) == null;
        return !notDefined || columnIndex != 0;
    }

    boolean hasVariableAtOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= ((StackFrameDataType)this.viewComposite).getNumComponents()) {
            return false;
        }
        return ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(ordinal) != null;
    }

    boolean hasVariableAtOffset(int offset) {
        return ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOffset(offset) != null;
    }

    StackFrameDataType getEditorStack() {
        return (StackFrameDataType)this.viewComposite;
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        super.clearSelectedComponents();
        this.setRelOffsetSelection(offsetSelection);
    }

    private OffsetPairs getRelOffsetSelection() {
        OffsetPairs offsets = new OffsetPairs();
        int num = this.selection.getNumRanges();
        int max = this.getNumComponents();
        for (int i = 0; i < num; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            int startOffset = this.getComponent(range.getStart().getIndex().intValue()).getOffset();
            int endOffset = range.getEnd().getIndex().intValue() < max ? this.getComponent(range.getEnd().getIndex().intValue()).getOffset() : ((StackFrameDataType)this.viewComposite).getPositiveLength() + ((StackFrameDataType)this.viewComposite).getParameterOffset();
            offsets.addPair(startOffset, endOffset);
        }
        return offsets;
    }

    private void setRelOffsetSelection(OffsetPairs offsets) {
        FieldSelection newSelection = new FieldSelection();
        int num = offsets.getNumPairs();
        int min = ((StackFrameDataType)this.viewComposite).getMinOffset();
        int max = ((StackFrameDataType)this.viewComposite).getMaxOffset();
        for (int i = 0; i < num; ++i) {
            int endIndex;
            XYPair pair = offsets.getPair(i);
            if (pair.y < min || pair.x > max) continue;
            int x = pair.x < min ? min : pair.x;
            int y = pair.y > max ? max + 1 : pair.y;
            StackFrameDataType.StackComponentWrapper startDtc = ((StackFrameDataType)this.viewComposite).getComponentAt(x);
            StackFrameDataType.StackComponentWrapper endDtc = ((StackFrameDataType)this.viewComposite).getComponentAt(y - 1);
            if (startDtc == null || endDtc == null) {
                return;
            }
            int startIndex = startDtc.getOrdinal();
            if (y <= max) {
                endIndex = endDtc.getOrdinal();
                if (endDtc.getOffset() != y) {
                    ++endIndex;
                }
            } else {
                endIndex = ((StackFrameDataType)this.viewComposite).getNumComponents();
            }
            newSelection.addRange(startIndex, endIndex);
        }
        this.setSelection(newSelection);
    }

    void setLocalSize(int size) throws UsrException {
        if (this.getLocalSize() == size) {
            return;
        }
        if (size > Integer.MAX_VALUE) {
            throw new UsrException("Local size cannot exceed 0x" + Integer.toHexString(Integer.MAX_VALUE) + ".");
        }
        ((StackFrameDataType)this.viewComposite).setLocalSize(size);
        this.notifyCompositeChanged();
    }

    void setParameterSize(int size) throws UsrException {
        if (this.getParameterSize() == size) {
            return;
        }
        if (size > Integer.MAX_VALUE) {
            throw new UsrException("Parameter size cannot exceed 0x" + Integer.toHexString(Integer.MAX_VALUE) + ".");
        }
        ((StackFrameDataType)this.viewComposite).setParameterSize(size);
        this.notifyCompositeChanged();
    }

    int getFrameSize() {
        return ((StackFrameDataType)this.viewComposite).getFrameSize();
    }

    int getLocalSize() {
        return ((StackFrameDataType)this.viewComposite).getLocalSize();
    }

    int getParameterSize() {
        return ((StackFrameDataType)this.viewComposite).getParameterSize();
    }

    int getParameterOffset() {
        return ((StackFrameDataType)this.viewComposite).getParameterOffset();
    }

    int getReturnAddressOffset() {
        return ((StackFrameDataType)this.viewComposite).getReturnAddressOffset();
    }

    @Override
    public int getMaxAddLength(int index) {
        return this.getMaxReplaceLength(index);
    }

    @Override
    public int getMaxReplaceLength(int currentIndex) {
        int offset = ((StackFrameDataType)this.viewComposite).getComponent(currentIndex).getOffset();
        return ((StackFrameDataType)this.viewComposite).getMaxLength(offset);
    }

    @Override
    public int getMaxDuplicates(int rowIndex) {
        return 0;
    }

    @Override
    public boolean isAddAllowed(DataType dataType) {
        if (this.isSingleRowSelection()) {
            return this.isAddAllowed(this.getMinIndexSelected(), dataType);
        }
        return false;
    }

    @Override
    public boolean isAddAllowed(int currentIndex, DataType dataType) {
        int offset;
        int maxBytes;
        if (currentIndex < 0 || currentIndex >= this.getRowCount()) {
            return false;
        }
        try {
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        StackFrameDataType.StackComponentWrapper comp = this.getComponent(currentIndex);
        DataType compDt = comp.getDataType();
        boolean existingPointer = compDt instanceof Pointer;
        boolean isPointer = dataType instanceof Pointer || existingPointer;
        int newLength = dataType.getLength();
        if (!isPointer && newLength <= 0) {
            return false;
        }
        if (existingPointer) {
            newLength = compDt.getLength();
        }
        return newLength <= (maxBytes = ((StackFrameDataType)this.viewComposite).getMaxLength(offset = comp.getOffset()));
    }

    @Override
    public boolean isBitFieldAllowed() {
        return false;
    }

    @Override
    public boolean isArrayAllowed() {
        if (this.getNumSelectedRows() != 1 || this.viewComposite == null) {
            return false;
        }
        int index = this.getMinIndexSelected();
        if (index < 0 || index >= ((StackFrameDataType)this.viewComposite).getNumComponents()) {
            return false;
        }
        StackFrameDataType.StackComponentWrapper dtc = ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(index);
        return dtc != null;
    }

    @Override
    public boolean isClearAllowed() {
        return this.getNumSelectedRows() > 0;
    }

    @Override
    public boolean isDeleteAllowed() {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        if (range.getStart().getIndex().intValue() == 0 || range.getEnd().getIndex().intValue() == this.getRowCount()) {
            int startOffset = this.getComponent(range.getStart().getIndex().intValue()).getOffset();
            int endOffset = this.getComponent(range.getEnd().getIndex().intValue() - 1).getEndOffset();
            if (startOffset < 0 && endOffset >= 0) {
                return false;
            }
            int paramOffset = this.getParameterOffset();
            return startOffset >= paramOffset || endOffset < paramOffset;
        }
        return false;
    }

    @Override
    public boolean isReplaceAllowed(int currentIndex, DataType dataType) {
        if (!(dataType instanceof Pointer) && dataType.getLength() <= 0) {
            return false;
        }
        try {
            if (currentIndex < 0 || currentIndex >= this.getRowCount()) {
                return false;
            }
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        int offset = this.getComponent(currentIndex).getOffset();
        int maxBytes = ((StackFrameDataType)this.viewComposite).getMaxLength(offset);
        return dataType.getLength() <= maxBytes;
    }

    @Override
    public void setComponentDataTypeInstance(int index, DataType dt, int length) throws UsrException {
        this.checkIsAllowableDataType(dt);
        ((StackFrameDataType)this.viewComposite).setDataType(index, dt, length);
    }

    @Override
    public void validateComponentName(int currentIndex, String name) throws UsrException {
        if (SymbolUtilities.containsInvalidChars((String)name)) {
            throw new InvalidInputException("Symbol name \"" + name + "\"contains invalid characters.");
        }
    }

    @Override
    public boolean setComponentName(int rowIndex, String newName) throws InvalidNameException {
        if (newName.trim().length() == 0) {
            newName = null;
        }
        String nameInEditor = (String)this.getValueAt(rowIndex, 3);
        if (((StackFrameDataType)this.viewComposite).isDefaultName(newName) && !this.isOriginalFieldName(newName, rowIndex)) {
            if (Objects.equals(nameInEditor, newName)) {
                return false;
            }
            throw new InvalidNameException("Cannot set a stack variable name to a default value");
        }
        if (((StackFrameDataType)this.viewComposite).setName(rowIndex, newName)) {
            this.updateAndCheckChangeState();
            this.fireTableCellUpdated(rowIndex, this.getNameColumn());
            this.notifyCompositeChanged();
            return true;
        }
        return false;
    }

    private boolean isOriginalFieldName(String testName, int rowIndex) {
        String fieldName = this.getFieldNameAtRow(rowIndex, this.originalStackFrameDataType);
        return SystemUtilities.isEqual((Object)fieldName, (Object)testName);
    }

    @Override
    public boolean setComponentComment(int currentIndex, String comment) {
        if (((StackFrameDataType)this.viewComposite).setComment(currentIndex, comment)) {
            this.updateAndCheckChangeState();
            this.fireTableRowsUpdated(currentIndex, currentIndex);
            this.componentDataChanged();
            return true;
        }
        return false;
    }

    @Override
    public DataTypeComponent add(DataType dataType) throws UsrException {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex < 0) {
            throw new UsrException("A component must be selected.");
        }
        return this.replace(rowIndex, dataType);
    }

    @Override
    public DataTypeComponent add(int index, DataType dt) throws UsrException {
        return this.replace(index, dt);
    }

    @Override
    public DataTypeComponent add(int index, DataType dt, int dtLength) throws UsrException {
        return this.replace(index, dt, dtLength);
    }

    private Variable getVariableContaining(int offset, List<Variable> sortedVariables) {
        Integer key = offset;
        int index = Collections.binarySearch(sortedVariables, key, StackVariableComparator.get());
        if (index >= 0) {
            return sortedVariables.get(index);
        }
        index = -index - 1;
        if (--index < 0) {
            return null;
        }
        Variable var = sortedVariables.get(index);
        int stackOffset = var.getStackOffset();
        if (stackOffset + var.getLength() > offset) {
            if (var.getDataType().isDeleted()) {
                sortedVariables.remove(index);
            } else {
                return var;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply() throws EmptyCompositeException, InvalidDataTypeException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.clearStatus();
        if (this.avoidApplyingConflictingData()) {
            return false;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        int transID = this.startTransaction("Apply \"" + this.getCompositeName() + "\" Stack Edits");
        try {
            int offset;
            Parameter p;
            if (!this.isValidName() || !this.hasChanges()) {
                boolean bl = false;
                return bl;
            }
            Variable[] newVars = ((StackFrameDataType)this.viewComposite).getStackVariables();
            List<Variable> newVarsList = Arrays.asList(newVars);
            Collections.sort(newVarsList, StackVariableComparator.get());
            StackFrame functionStackFrame = this.function.getStackFrame();
            functionStackFrame.setLocalSize(((StackFrameDataType)this.viewComposite).getLocalSize());
            functionStackFrame.setReturnAddressOffset(((StackFrameDataType)this.viewComposite).getReturnAddressOffset());
            Parameter[] origParams = this.function.getParameters();
            for (int i = origParams.length - 1; i >= 0 && (p = origParams[i]).hasStackStorage() && !p.isAutoParameter() && this.getVariableContaining(offset = (int)p.getVariableStorage().getLastVarnode().getAddress().getOffset(), newVarsList) == null; --i) {
                p.getSymbol().delete();
            }
            for (Variable var : this.function.getAllVariables()) {
                int offset2;
                if (!var.hasStackStorage() || var.getSymbol() == null || this.getVariableContaining(offset2 = (int)var.getVariableStorage().getLastVarnode().getAddress().getOffset(), newVarsList) != null) continue;
                if (var instanceof Parameter && !this.function.hasCustomVariableStorage()) {
                    this.function.setCustomVariableStorage(true);
                }
                var.getSymbol().delete();
            }
            for (Variable sv : newVars) {
                Variable newSv = null;
                try {
                    DataType dt = this.originalDTM.resolve(sv.getDataType(), null);
                    Variable var = functionStackFrame.getVariableContaining(sv.getStackOffset());
                    if (var != null && var.getStackOffset() == sv.getStackOffset() && var.getLength() == sv.getLength()) {
                        newSv = var;
                        if (!newSv.getName().equals(sv.getName())) {
                            newSv.setName(sv.getName(), SourceType.USER_DEFINED);
                        }
                        if (!dt.equals((Object)newSv.getDataType())) {
                            newSv.setDataType(dt, SourceType.USER_DEFINED);
                        }
                    } else {
                        if (functionStackFrame.isParameterOffset(sv.getStackOffset()) || var instanceof Parameter) {
                            functionStackFrame.getFunction().setCustomVariableStorage(true);
                        }
                        if (var != null) {
                            functionStackFrame.clearVariable(var.getStackOffset());
                        }
                        newSv = functionStackFrame.createVariable(sv.getName(), sv.getStackOffset(), dt, SourceType.USER_DEFINED);
                    }
                    newSv.setComment(sv.getComment());
                }
                catch (DuplicateNameException e) {
                    Msg.showError((Object)this, null, (String)"Stack Edit Error", (Object)("Stack variable error at offset " + sv.getStackOffset() + ": " + e.getMessage()));
                    continue;
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)this, null, (String)"Stack Edit Error", (Object)("Stack variable error at offset " + sv.getStackOffset() + ": " + e.getMessage()));
                    continue;
                }
                String comment = sv.getComment();
                if (comment == null) continue;
                newSv.setComment(comment);
            }
            this.load(this.function);
            this.clearStatus();
            boolean bl = true;
            return bl;
        }
        finally {
            this.endTransaction(transID);
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    private boolean avoidApplyingConflictingData() {
        if (!this.hasChanges()) {
            return true;
        }
        if (!this.stackChangedExternally) {
            return false;
        }
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this.provider.getComponent(), (String)"Overwrite Program Changes?", (String)"<html>The function's stack data has changed outside of this<br>Stack Editor Provider.<br><BR>Would you like to overwrite the external changes with your changes?", (String)"Overwrite", (int)2);
        return choice == 0;
    }

    protected int startTransaction(String startMsg) {
        Program program = ((StackEditorProvider)this.provider).getProgram();
        if (program != null) {
            return program.startTransaction(startMsg);
        }
        return -1;
    }

    protected void endTransaction(int transID) {
        Program program = ((StackEditorProvider)this.provider).getProgram();
        if (program != null) {
            program.endTransaction(transID, true);
        }
    }

    @Override
    public void duplicateMultiple(int index, int multiple, TaskMonitor monitor) throws UsrException {
    }

    @Override
    public DataTypeComponent insert(DataType dataType) throws UsrException {
        return null;
    }

    @Override
    public DataTypeComponent insert(int index, DataType dataType) throws UsrException {
        return null;
    }

    @Override
    public DataTypeComponent insert(int index, DataType dt, int dtLength) throws UsrException {
        return null;
    }

    @Override
    public boolean moveUp() {
        return false;
    }

    @Override
    public boolean moveDown() {
        return false;
    }

    private DataTypeComponent replace(int index, DataType dataType) throws UsrException {
        try {
            DataTypeInstance dti = this.getDropDataType(index, dataType);
            return this.replace(index, dti.getDataType(), dti.getLength());
        }
        catch (CancelledException e) {
            return null;
        }
    }

    @Override
    public DataTypeComponent replace(int index, DataType dt, int dtLength) throws UsrException {
        this.fieldEdited(DataTypeInstance.getDataTypeInstance((DataType)dt, (int)dtLength, (boolean)this.usesAlignedLengthComponents()), index, this.getDataTypeColumn());
        this.setSelection(new int[]{index});
        return this.getComponent(index);
    }

    @Override
    public int getMaxElements() {
        if (this.getNumSelectedComponentRows() != 1) {
            return 0;
        }
        int index = this.getMinIndexSelected();
        if (index < 0 || index >= ((StackFrameDataType)this.viewComposite).getNumComponents()) {
            this.setStatus("Can only create arrays on a defined stack variable.", true);
            return 0;
        }
        StackFrameDataType.StackComponentWrapper dtc = ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(index);
        if (dtc == null) {
            this.setStatus("Can only create arrays on a defined stack variable.", true);
            return 0;
        }
        int max = this.getMaxReplaceLength(index);
        if (max == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return max / dtc.getDataType().getAlignedLength();
    }

    @Override
    public void restored(DataTypeManager dataTypeManager) {
        this.functionChanged(true);
    }

    void functionChanged(boolean isRestore) {
        if (this.function.isDeleted()) {
            PluginTool tool = ((StackEditorProvider)this.provider).getPlugin().getTool();
            tool.setStatusInfo("Stack Editor was closed for " + this.provider.getName());
            this.provider.dispose();
            return;
        }
        this.updateAndCheckChangeState();
        boolean reload = true;
        if (this.hasChanges) {
            String text = isRestore ? "may have " : "";
            String question = "The function \"" + this.currentName + "\" " + text + "changed outside the editor.\nDiscard edits and reload the Stack Editor?";
            String title = "Reload Stack Editor?";
            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this.provider.getComponent(), (String)title, (String)question);
            if (response != 1) {
                reload = false;
            }
        }
        if (reload) {
            this.load(this.function);
        } else {
            this.stackChangedExternally(true);
            this.refresh();
        }
    }

    public void dataTypeRemoved(DataTypeManager dataTypeManager, DataTypePath path) {
        if (dataTypeManager != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        DataType dataType = this.viewDTM.getDataType(path.getCategoryPath(), path.getDataTypeName());
        if (dataType == null || !this.viewDTM.isViewDataTypeFromOriginalDTM(dataType)) {
            return;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        this.viewDTM.remove(dataType);
        this.fireTableDataChanged();
        this.componentDataChanged();
        this.setRelOffsetSelection(offsetSelection);
    }

    public void dataTypeRenamed(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath) {
        this.dataTypeMoved(dataTypeManager, oldPath, newPath);
    }

    public void dataTypeMoved(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath) {
        if (dataTypeManager != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        if (oldPath.getDataTypeName().equals(newPath.getDataTypeName())) {
            return;
        }
        DataType originalDt = this.originalDTM.getDataType(newPath);
        if (!(originalDt instanceof DatabaseObject)) {
            return;
        }
        DataType dt = this.viewDTM.findMyDataTypeFromOriginalID(this.originalDTM.getID(originalDt));
        if (dt == null) {
            return;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        try {
            dt.setName(newPath.getDataTypeName());
            CategoryPath newCategoryPath = newPath.getCategoryPath();
            CategoryPath oldCategoryPath = oldPath.getCategoryPath();
            if (!newCategoryPath.equals((Object)oldCategoryPath)) {
                dt.setCategoryPath(newCategoryPath);
            }
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        this.fireTableDataChanged();
        this.componentDataChanged();
        this.setRelOffsetSelection(offsetSelection);
    }

    public void dataTypeChanged(DataTypeManager dataTypeManager, DataTypePath path) {
        if (dataTypeManager != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        DataType changedDt = this.originalDTM.getDataType(path);
        if (!(changedDt instanceof DatabaseObject)) {
            return;
        }
        DataType viewDt = this.viewDTM.findMyDataTypeFromOriginalID(this.originalDTM.getID(changedDt));
        if (viewDt == null) {
            return;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        try {
            this.viewDTM.replaceDataType(viewDt, changedDt, true);
            ((StackFrameDataType)this.viewComposite).checkForStackGrowth();
        }
        catch (DataTypeDependencyException e) {
            throw new AssertException((Throwable)e);
        }
        this.compositeInfoChanged();
        this.fireTableDataChanged();
        this.componentDataChanged();
        this.setRelOffsetSelection(offsetSelection);
    }

    public void dataTypeReplaced(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        if (dataTypeManager != this.originalDTM) {
            throw new AssertException("Listener only supports original DTM");
        }
        if (!this.isLoaded()) {
            return;
        }
        DataType dt = this.viewDTM.getDataType(oldPath);
        if (dt == null || !this.viewDTM.isViewDataTypeFromOriginalDTM(dt)) {
            return;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        try {
            this.viewDTM.replaceDataType(dt, newDataType, true);
            ((StackFrameDataType)this.viewComposite).checkForStackGrowth();
        }
        catch (DataTypeDependencyException e) {
            throw new AssertException((Throwable)e);
        }
        this.compositeInfoChanged();
        this.fireTableDataChanged();
        this.componentDataChanged();
        this.setRelOffsetSelection(offsetSelection);
    }

    @Override
    protected StackFrameDataType getOriginalComposite() {
        return (StackFrameDataType)this.originalComposite;
    }

    @Override
    protected boolean originalCompositeExists() {
        return false;
    }

    @Override
    protected DataTypeManager getOriginalDataTypeManager() {
        return super.getOriginalDataTypeManager();
    }

    @Override
    protected long getCompositeID() {
        return super.getCompositeID();
    }

    protected void refresh() {
        if (this.isLoaded()) {
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            this.refreshComponents();
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.compositeInfoChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    private void refreshComponents() {
        StackFrameDataType.StackComponentWrapper[] comps = ((StackFrameDataType)this.viewComposite).getDefinedComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            long myId;
            StackFrameDataType.StackComponentWrapper component = comps[i];
            DataType compDt = component.getDataType();
            if (!(compDt instanceof DatabaseObject) || this.viewDTM.findOriginalDataTypeFromMyID(myId = this.viewDTM.getID(compDt)) != null) continue;
            this.clearComponent(component.getOrdinal());
        }
        this.viewDTM.refreshDBTypesFromOriginal();
    }

    @Override
    protected void clearComponents(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            ((StackFrameDataType)this.viewComposite).clearComponent(rows[i]);
        }
        this.notifyCompositeChanged();
    }

    @Override
    protected void deleteComponent(int rowIndex) {
        ((StackFrameDataType)this.viewComposite).delete(rowIndex);
        this.compositeInfoChanged();
        this.fireTableDataChanged();
    }

    @Override
    public StackFrameDataType.StackComponentWrapper getComponent(int rowIndex) {
        if (this.viewComposite == null) {
            return null;
        }
        return ((StackFrameDataType)this.viewComposite).getComponent(rowIndex);
    }

    @Override
    public int getNumComponents() {
        if (this.viewComposite == null) {
            return 0;
        }
        return ((StackFrameDataType)this.viewComposite).getNumComponents();
    }

    @Override
    public boolean isShowingUndefinedBytes() {
        return true;
    }

    private class OffsetPairs {
        ArrayList<XYPair> pairs = new ArrayList();

        OffsetPairs() {
        }

        void addPair(int x, int y) {
            this.pairs.add(new XYPair(StackEditorModel.this, x, y));
        }

        int getNumPairs() {
            return this.pairs.size();
        }

        XYPair getPair(int i) {
            if (i >= 0 && i < this.pairs.size()) {
                return this.pairs.get(i);
            }
            return null;
        }
    }

    private class XYPair {
        int x;
        int y;

        XYPair(StackEditorModel stackEditorModel, int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

