/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.InteriorSelection;
import java.util.Iterator;
import java.util.Objects;

public class ProgramSelection
implements AddressSetView {
    private AddressSet addressSet;
    private InteriorSelection interiorSelection;

    public ProgramSelection() {
        this.addressSet = new AddressSet();
    }

    public ProgramSelection(Address from, Address to) {
        this();
        if (to.compareTo((Object)from) < 0) {
            Address temp = to;
            to = from;
            from = temp;
        }
        this.addressSet.addRange(from, to);
    }

    public ProgramSelection(AddressSetView setView) {
        this.addressSet = new AddressSet(setView);
    }

    public ProgramSelection(InteriorSelection sel) {
        this(sel.getStartAddress(), sel.getEndAddress());
        this.interiorSelection = sel;
    }

    @Deprecated(since="11.2", forRemoval=true)
    public ProgramSelection(AddressFactory addressFactory) {
        this();
    }

    @Deprecated(since="11.2", forRemoval=true)
    public ProgramSelection(AddressFactory addressFactory, Address from, Address to) {
        this(from, to);
    }

    @Deprecated(since="11.2", forRemoval=true)
    public ProgramSelection(AddressFactory addressFactory, AddressSetView setView) {
        this(setView);
    }

    @Deprecated(since="11.2", forRemoval=true)
    public ProgramSelection(AddressFactory addressFactory, InteriorSelection sel) {
        this(sel);
    }

    public InteriorSelection getInteriorSelection() {
        return this.interiorSelection;
    }

    public int hashCode() {
        return Objects.hash(this.interiorSelection, this.addressSet);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramSelection ps = (ProgramSelection)obj;
        if (this.interiorSelection != null) {
            return this.interiorSelection.equals(ps.interiorSelection);
        }
        return this.addressSet.hasSameAddresses((AddressSetView)ps.addressSet);
    }

    public boolean contains(Address addr) {
        return this.addressSet.contains(addr);
    }

    public boolean contains(Address start, Address end) {
        return this.addressSet.contains(start, end);
    }

    public boolean contains(AddressSetView rangeSet) {
        return this.addressSet.contains(rangeSet);
    }

    public boolean intersects(AddressSetView addrSet) {
        return this.addressSet != null && this.addressSet.intersects(addrSet);
    }

    public AddressSet intersect(AddressSetView view) {
        return this.addressSet.intersect(view);
    }

    public AddressSet intersectRange(Address start, Address end) {
        return this.addressSet.intersectRange(start, end);
    }

    public boolean isEmpty() {
        return this.addressSet.isEmpty();
    }

    public Address getMinAddress() {
        return this.addressSet.getMinAddress();
    }

    public Address getMaxAddress() {
        return this.addressSet.getMaxAddress();
    }

    public int getNumAddressRanges() {
        return this.addressSet.getNumAddressRanges();
    }

    public AddressRangeIterator getAddressRanges(boolean atStart) {
        return this.addressSet.getAddressRanges(atStart);
    }

    public AddressRangeIterator getAddressRanges() {
        return this.addressSet.getAddressRanges();
    }

    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    public long getNumAddresses() {
        return this.addressSet.getNumAddresses();
    }

    public AddressIterator getAddresses(boolean forward) {
        return this.addressSet.getAddresses(forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.addressSet.getAddresses(start, forward);
    }

    public boolean hasSameAddresses(AddressSetView asv) {
        if (asv instanceof ProgramSelection) {
            return this.equals(asv);
        }
        return this.addressSet.hasSameAddresses(asv);
    }

    public boolean intersects(Address start, Address end) {
        return this.addressSet.intersects(start, end);
    }

    public AddressSet union(AddressSetView view) {
        return this.addressSet.union(view);
    }

    public AddressSet xor(AddressSetView view) {
        return this.addressSet.xor(view);
    }

    public AddressSet subtract(AddressSetView view) {
        return this.addressSet.subtract(view);
    }

    public String toString() {
        if (this.interiorSelection != null) {
            return "Interior Selection: " + String.valueOf(this.interiorSelection);
        }
        return "ProgramSelection: " + String.valueOf(this.addressSet);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.addressSet.getAddressRanges(start, forward);
    }

    public AddressRange getFirstRange() {
        return this.addressSet.getFirstRange();
    }

    public AddressRange getLastRange() {
        return this.addressSet.getLastRange();
    }

    public AddressRange getRangeContaining(Address address) {
        return this.addressSet.getRangeContaining(address);
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.addressSet.iterator(forward);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.addressSet.iterator(start, forward);
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        return this.addressSet.findFirstAddressInCommon(set);
    }
}

