/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.compat;

import com.intellij.util.text.VersionComparatorUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.mvn.MavenContext;

public class MavenContextFactory {
    public static MavenContext createMavenContext(InvokerRequest invokerRequest) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"4.0.0-rc-3") == 0) {
            Constructor<?>[] constructors = MavenContext.class.getConstructors();
            Constructor constructor = Arrays.stream(constructors).filter(it -> it.getParameterCount() == 2).findFirst().orElse(null);
            if (constructors.length != 2 || constructor == null) {
                throw new UnsupportedOperationException("MavenContext: Wrong constructors. This maven is incompatibile with current IDEA version");
            }
            try {
                return (MavenContext)constructor.newInstance(invokerRequest, false);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UnsupportedOperationException(" This maven is incompatibile with current IDEA version", e);
            }
        }
        Options mavenOptions = invokerRequest.options().orElse(null);
        return new MavenContext(invokerRequest, false, (MavenOptions)mavenOptions);
    }
}

