/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.backend;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.serviceView.backend.ServiceViewLocatableSearcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/execution/dashboard/backend/RunDashboardLocatableSearcher;", "Lcom/intellij/platform/execution/serviceView/backend/ServiceViewLocatableSearcher;", "<init>", "()V", "find", "", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.execution.dashboard.backend"})
public final class RunDashboardLocatableSearcher
implements ServiceViewLocatableSearcher {
    @NotNull
    public List<String> find(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        List result = new ArrayList();
        List services = RunDashboardManagerImpl.getInstance((Project)project).getRunConfigurations();
        block0: for (RunDashboardService service : services) {
            List customizers;
            Intrinsics.checkNotNullExpressionValue((Object)RunDashboardManagerImpl.getCustomizers((RunnerAndConfigurationSettings)service.getConfigurationSettings(), (RunContentDescriptor)service.getDescriptor()), (String)"getCustomizers(...)");
            for (RunDashboardCustomizer customizer : customizers) {
                PsiElement psiElement;
                if (customizer.getPsiElement(service.getConfigurationSettings().getConfiguration()) == null || !Intrinsics.areEqual((Object)virtualFile, (Object)PsiUtilCore.getVirtualFile((PsiElement)psiElement))) continue;
                String string = service.getServiceViewId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServiceViewId(...)");
                result.add(string);
                continue block0;
            }
        }
        return result;
    }
}

