/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalReader;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationRow;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMutationModel
implements GridModel<GridRow, GridColumn> {
    private final GridModel<GridRow, GridColumn> myModel;
    private final Map<ModelIndex<GridRow>, GridRow> myCache;
    private final GridDataHookUp<GridRow, GridColumn> myHookUp;
    private final EventDispatcher<GridModel.Listener> myDispatcher;

    public GridMutationModel(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp) {
        if (hookUp == null) {
            GridMutationModel.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(GridModel.Listener.class);
        this.myHookUp = hookUp;
        this.myModel = this.myHookUp.getDataModel();
        this.myCache = new ConcurrentHashMap<ModelIndex<GridRow>, GridRow>();
    }

    @Override
    @NotNull
    public List<GridColumn> getColumns() {
        List list = this.getColumnIndicesInner().map(this::wrapColumn).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<GridColumn> getColumnsAsIterable() {
        JBIterable jBIterable = this.getColumnIndicesInner().map(this::wrapColumn);
        if (jBIterable == null) {
            GridMutationModel.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<GridColumn> getColumns(@NotNull ModelIndexSet<GridColumn> columnsIdxs) {
        if (columnsIdxs == null) {
            GridMutationModel.$$$reportNull$$$0(3);
        }
        List list = columnsIdxs.asIterable().filter(this::isValidColumnIdx).map(this::wrapColumn).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<GridColumn> getColumnsAsIterable(@NotNull ModelIndexSet<GridColumn> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = columns.asIterable().filter(this::isValidColumnIdx).map(this::wrapColumn);
        if (jBIterable == null) {
            GridMutationModel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public GridColumn getColumn(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(7);
        }
        return !this.isValidColumnIdx(columnIdx) ? null : this.wrapColumn(columnIdx);
    }

    @Override
    @NotNull
    public List<GridRow> getRows(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(8);
        }
        List list = rows.asIterable().filter(this::isValidRowIdx).map(this::wrapRow).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<GridRow> row, ModelIndex<GridColumn> column) {
        return GridMutationModel.getValueAt(row, column, this.myHookUp.getMutator(), this.myModel);
    }

    @Nullable
    public static Object getValueAt(ModelIndex<GridRow> row, ModelIndex<GridColumn> column, @Nullable GridMutator<GridRow, GridColumn> mutator, @NotNull GridModel<GridRow, GridColumn> model) {
        MutationData value;
        if (model == null) {
            GridMutationModel.$$$reportNull$$$0(10);
        }
        GridMutator.DatabaseMutator databaseMutator = (GridMutator.DatabaseMutator)ObjectUtils.tryCast(mutator, GridMutator.DatabaseMutator.class);
        GridMutator.ColumnsMutator columnsMutator = (GridMutator.ColumnsMutator)ObjectUtils.tryCast(mutator, GridMutator.ColumnsMutator.class);
        MutationData mutationData = value = databaseMutator == null ? null : databaseMutator.getMutation(row, column);
        return value != null ? value.getValue() : (row.isValid(model) && column.isValid(model) ? model.getValueAt(row, column) : (columnsMutator != null && (columnsMutator.isDeletedColumn(column) || columnsMutator.isInsertedColumn(column)) ? ReservedCellValue.UNSET : null));
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, Object what) {
        if (rowIndices == null) {
            GridMutationModel.$$$reportNull$$$0(11);
        }
        if (columnIndices == null) {
            GridMutationModel.$$$reportNull$$$0(12);
        }
        return this.myModel.allValuesEqualTo(rowIndices, columnIndices, what) && (this.getDatabaseMutator() == null || !this.getDatabaseMutator().hasMutatedRows(rowIndices, columnIndices));
    }

    @Override
    @Nullable
    public GridRow getRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            GridMutationModel.$$$reportNull$$$0(13);
        }
        return !this.isValidRowIdx(row) ? null : this.wrapRow(row);
    }

    @Override
    @NotNull
    public List<GridRow> getRows() {
        List list = this.getRowIndicesInner().map(this::wrapRow).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private GridRow wrapRow(@NotNull ModelIndex<GridRow> rowIdx) {
        GridMutator.DatabaseMutator<GridRow, GridColumn> mutator;
        if (rowIdx == null) {
            GridMutationModel.$$$reportNull$$$0(15);
        }
        MutationType type = (mutator = this.getDatabaseMutator()) == null ? null : mutator.getMutationType(rowIdx);
        return type == MutationType.MODIFY || type == MutationType.INSERT ? this.myCache.computeIfAbsent(rowIdx, r -> new MutationRow(rowIdx, new Object[this.getColumnCount()], mutator, this.myModel)) : this.myModel.getRow(rowIdx);
    }

    @Nullable
    private GridColumn wrapColumn(@NotNull ModelIndex<GridColumn> columnIdx) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(16);
        }
        GridColumn column = (mutator = this.getColumnsMutator()) == null ? null : mutator.getInsertedColumn(columnIdx);
        return column != null ? column : this.myModel.getColumn(columnIdx);
    }

    @Override
    @NotNull
    public ModelIndexSet<GridColumn> getColumnIndices() {
        ModelIndexSet<GridColumn> modelIndexSet = ModelIndexSet.forColumns(this.myModel, this.getColumnIndicesInner());
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(17);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<GridRow> getRowIndices() {
        ModelIndexSet<GridRow> modelIndexSet = ModelIndexSet.forRows(this.myModel, this.getRowIndicesInner());
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(18);
        }
        return modelIndexSet;
    }

    private JBIterable<ModelIndex<GridRow>> getRowIndicesInner() {
        GridMutator.RowsMutator<GridRow, GridColumn> mutator = this.getRowsMutator();
        return this.myModel.getRowIndices().asIterable().append(mutator == null ? ContainerUtil.emptyList() : mutator.getInsertedRows());
    }

    private JBIterable<ModelIndex<GridColumn>> getColumnIndicesInner() {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator = this.getColumnsMutator();
        return this.myModel.getColumnIndices().asIterable().append(mutator == null ? ContainerUtil.emptyList() : mutator.getInsertedColumns());
    }

    @Override
    public int getColumnCount() {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator = this.getColumnsMutator();
        return this.myModel.getColumnCount() + (mutator == null ? 0 : mutator.getInsertedColumnsCount());
    }

    @Override
    public int getRowCount() {
        GridMutator.RowsMutator<GridRow, GridColumn> mutator = this.getRowsMutator();
        return this.myModel.getRowCount() + (mutator == null ? 0 : mutator.getInsertedRowsCount());
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            GridMutationModel.$$$reportNull$$$0(19);
        }
        GridMutator.RowsMutator<GridRow, GridColumn> mutator = this.getRowsMutator();
        return this.myModel.isValidRowIdx(rowIdx) || mutator != null && mutator.isInsertedRow(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(20);
        }
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator = this.getColumnsMutator();
        return this.myModel.isValidColumnIdx(columnIdx) || mutator != null && mutator.isInsertedColumn(columnIdx);
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<GridRow, GridColumn> l, @NotNull Disposable disposable) {
        if (l == null) {
            GridMutationModel.$$$reportNull$$$0(21);
        }
        if (disposable == null) {
            GridMutationModel.$$$reportNull$$$0(22);
        }
        this.myDispatcher.addListener(l, disposable);
    }

    @Override
    public boolean hasListeners() {
        return this.myDispatcher.hasListeners();
    }

    @Override
    public List<GridColumn> getAllColumnsForExtraction(int ... selection) {
        return this.myModel.getAllColumnsForExtraction(selection);
    }

    @Nullable
    private GridMutator.DatabaseMutator<GridRow, GridColumn> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator.RowsMutator<GridRow, GridColumn> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.ColumnsMutator<GridRow, GridColumn> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.ColumnsMutator.class);
    }

    public void afterLastRowAdded() {
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).afterLastRowAdded();
    }

    public void notifyCellsUpdated(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(23);
        }
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(24);
        }
        if (rows.size() == 0 || columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).cellsUpdated(rows, columns, place);
    }

    public void notifyRowsAdded(@NotNull ModelIndexSet<GridRow> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(25);
        }
        if (rows.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsAdded(rows);
    }

    public void notifyRowsRemoved(ModelIndexSet<GridRow> rows) {
        if (rows.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsRemoved(rows);
    }

    public void notifyColumnsAdded(@NotNull ModelIndexSet<GridColumn> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(26);
        }
        if (columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsAdded(columns);
    }

    public void notifyColumnsRemoved(@NotNull ModelIndexSet<GridColumn> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(27);
        }
        if (columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsRemoved(columns);
    }

    @Override
    @Nullable
    public HierarchicalReader getHierarchicalReader() {
        return this.myModel.getHierarchicalReader();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 9, 14, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 5: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 7: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnIndices";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsAsIterable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "allValuesEqualTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrapRow";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapColumn";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyCellsUpdated";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyRowsAdded";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyColumnsAdded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyColumnsRemoved";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 9, 14, 17, 18 -> new IllegalStateException(string);
        };
    }
}

