/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Fast binary erosion of a single intensity value in the image.


BinaryErodeImageFilter is a binary erosion morphologic operation on the foreground of an
image. Only the value designated by the intensity value
"SetForegroundValue()" (alias as SetErodeValue() ) is considered as
foreground, and other intensity values are considered background.

Grayscale images can be processed as binary images by selecting a
"ForegroundValue" (alias "ErodeValue"). Pixel values matching the
erode value are considered the "foreground" and all other pixels are
"background". This is useful in processing segmented images where
all pixels in segment #1 have value 1 and pixels in segment #2 have
value 2, etc. A particular "segment number" can be processed.
ForegroundValue defaults to the maximum possible value of the
PixelType. The eroded pixels will receive the BackgroundValue
(defaults to NumericTraits::NonpositiveMin() ).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel. A reasonable
choice of structuring element is itk::BinaryBallStructuringElement .

This implementation is based on the papers:

L.Vincent "Morphological transformations of binary images with
arbitrary structuring elements", and

N.Nikopoulos et al. "An efficient algorithm for 3d binary
morphological transformations with 3d structuring elements for
arbitrary size and shape". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.


See:
 ImageToImageFilter BinaryDilateImageFilter BinaryMorphologyImageFilter

 itk::simple::BinaryErode for the procedural interface

 itk::BinaryErodeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryErodeImageFilter.h
*/
public class BinaryErodeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryErodeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryErodeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryErodeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryErodeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryErodeImageFilter::~BinaryErodeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryErodeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryErodeImageFilter::BinaryErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryErodeImageFilter() {
    this(SimpleITKJNI.new_BinaryErodeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryErodeImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryErodeImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryErodeImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryErodeImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryErodeImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryErodeImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryErodeImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetBackgroundValue(double BackgroundValue)
*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryErodeImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryErodeImageFilter::GetBackgroundValue() const
*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryErodeImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetForegroundValue(double ForegroundValue)
*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryErodeImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryErodeImageFilter::GetForegroundValue() const
*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryErodeImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::SetBoundaryToForeground(bool BoundaryToForeground)
*/
public  void setBoundaryToForeground(boolean BoundaryToForeground) {
    SimpleITKJNI.BinaryErodeImageFilter_setBoundaryToForeground(swigCPtr, this, BoundaryToForeground);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOn()

Set the value of BoundaryToForeground to true or false respectfully.

*/
public  void boundaryToForegroundOn() {
    SimpleITKJNI.BinaryErodeImageFilter_boundaryToForegroundOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOff()
*/
public  void boundaryToForegroundOff() {
    SimpleITKJNI.BinaryErodeImageFilter_boundaryToForegroundOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryErodeImageFilter::GetBoundaryToForeground() const
*/
public  boolean getBoundaryToForeground() {
    return SimpleITKJNI.BinaryErodeImageFilter_getBoundaryToForeground(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryErodeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryErodeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryErodeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryErodeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryErodeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryErodeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
