/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class PlaceholderExpression
implements Expression {
    public static final Pattern PATTERN_PLACEHOLDER = Pattern.compile("\\{(\\d+)\\.(key|value|tag)}");
    private final String placeholder;

    public PlaceholderExpression(String placeholder) {
        CheckParameterUtil.ensureParameterNotNull(placeholder);
        this.placeholder = placeholder.intern();
    }

    @Override
    public Object evaluate(Environment env) {
        if (env.selector() == null) {
            return this.placeholder;
        }
        return PlaceholderExpression.insertArguments(env.selector(), this.placeholder, env.osm);
    }

    public static String insertArguments(Selector matchingSelector, String s, Tagged p) {
        if (s != null && matchingSelector instanceof Selector.ChildOrParentSelector) {
            return PlaceholderExpression.insertArguments(((Selector.ChildOrParentSelector)matchingSelector).right, s, p);
        }
        if (s == null || !(matchingSelector instanceof Selector.GeneralSelector)) {
            return s;
        }
        Matcher m = PATTERN_PLACEHOLDER.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String argument = PlaceholderExpression.determineArgument(matchingSelector, Integer.parseInt(m.group(1)), m.group(2), p);
            try {
                m.appendReplacement(sb, String.valueOf(argument).replace("^(", "").replace(")$", ""));
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                Logging.log(Logging.LEVEL_ERROR, I18n.tr("Unable to replace argument {0} in {1}: {2}", argument, sb, e.getMessage()), e);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String determineArgument(Selector matchingSelector, int index, String type, Tagged p) {
        try {
            Tag tag;
            Condition c = matchingSelector.getConditions().get(index);
            Tag tag2 = tag = c instanceof Condition.TagCondition ? ((Condition.TagCondition)c).asTag(p) : null;
            if (tag == null) {
                return null;
            }
            if ("key".equals(type)) {
                return tag.getKey();
            }
            if ("value".equals(type)) {
                return tag.getValue();
            }
            if ("tag".equals(type)) {
                return tag.toString();
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            Logging.debug(ioobe);
        }
        return null;
    }

    public String toString() {
        return "<" + this.placeholder + ">";
    }
}

