/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.List;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;
import org.apache.kafka.timeline.TimelineObject;
import org.slf4j.Logger;

public class ProducerIdControlManager {
    private final Logger log;
    private final ClusterControlManager clusterControlManager;
    private final TimelineObject<ProducerIdsBlock> nextProducerBlock;
    private final TimelineLong brokerEpoch;

    private ProducerIdControlManager(LogContext logContext, ClusterControlManager clusterControlManager, SnapshotRegistry snapshotRegistry) {
        this.log = logContext.logger(ProducerIdControlManager.class);
        this.clusterControlManager = clusterControlManager;
        this.nextProducerBlock = new TimelineObject(snapshotRegistry, (Object)ProducerIdsBlock.EMPTY);
        this.brokerEpoch = new TimelineLong(snapshotRegistry);
    }

    ControllerResult<ProducerIdsBlock> generateNextProducerId(int brokerId, long brokerEpoch) {
        this.clusterControlManager.checkBrokerEpoch(brokerId, brokerEpoch);
        long firstProducerIdInBlock = ((ProducerIdsBlock)this.nextProducerBlock.get()).firstProducerId();
        if (firstProducerIdInBlock > 9223372036854774807L) {
            throw new UnknownServerException("Exhausted all producerIds as the next block's end producerId has exceeded the int64 type limit");
        }
        ProducerIdsBlock block = new ProducerIdsBlock(brokerId, firstProducerIdInBlock, 1000);
        long newNextProducerId = block.nextBlockFirstId();
        ProducerIdsRecord record = new ProducerIdsRecord().setNextProducerId(newNextProducerId).setBrokerId(brokerId).setBrokerEpoch(brokerEpoch);
        return ControllerResult.of(List.of(new ApiMessageAndVersion((ApiMessage)record, 0)), block);
    }

    ProducerIdsBlock nextProducerBlock() {
        return (ProducerIdsBlock)this.nextProducerBlock.get();
    }

    void replay(ProducerIdsRecord record) {
        ProducerIdsBlock nextBlock = (ProducerIdsBlock)this.nextProducerBlock.get();
        if (nextBlock != ProducerIdsBlock.EMPTY && record.nextProducerId() <= nextBlock.firstProducerId()) {
            throw new RuntimeException("Next Producer ID from replayed record (" + record.nextProducerId() + ") is not greater than current next Producer ID in block (" + String.valueOf(nextBlock) + ")");
        }
        this.log.info("Replaying ProducerIdsRecord {}", (Object)record);
        this.nextProducerBlock.set((Object)new ProducerIdsBlock(record.brokerId(), record.nextProducerId(), 1000));
        this.brokerEpoch.set(record.brokerEpoch());
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private ClusterControlManager clusterControlManager = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setClusterControlManager(ClusterControlManager clusterControlManager) {
            this.clusterControlManager = clusterControlManager;
            return this;
        }

        ProducerIdControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.clusterControlManager == null) {
                throw new RuntimeException("You must specify ClusterControlManager.");
            }
            return new ProducerIdControlManager(this.logContext, this.clusterControlManager, this.snapshotRegistry);
        }
    }
}

