/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.internals.CacheFunction;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;

class SegmentedCacheFunction
implements CacheFunction {
    private static final int SEGMENT_ID_BYTES = 8;
    private final SegmentedBytesStore.KeySchema keySchema;
    private final long segmentInterval;

    SegmentedCacheFunction(SegmentedBytesStore.KeySchema keySchema, long segmentInterval) {
        this.keySchema = keySchema;
        this.segmentInterval = segmentInterval;
    }

    @Override
    public Bytes key(Bytes cacheKey) {
        return Bytes.wrap((byte[])SegmentedCacheFunction.bytesFromCacheKey(cacheKey));
    }

    @Override
    public Bytes cacheKey(Bytes key) {
        return this.cacheKey(key, this.segmentId(key));
    }

    Bytes cacheKey(Bytes key, long segmentId) {
        byte[] keyBytes = key.get();
        ByteBuffer buf = ByteBuffer.allocate(8 + keyBytes.length);
        buf.putLong(segmentId).put(keyBytes);
        return Bytes.wrap((byte[])buf.array());
    }

    static byte[] bytesFromCacheKey(Bytes cacheKey) {
        byte[] binaryKey = new byte[cacheKey.get().length - 8];
        System.arraycopy(cacheKey.get(), 8, binaryKey, 0, binaryKey.length);
        return binaryKey;
    }

    public long segmentId(Bytes key) {
        return this.segmentId(this.keySchema.segmentTimestamp(key));
    }

    long segmentId(long timestamp) {
        return timestamp / this.segmentInterval;
    }

    long getSegmentInterval() {
        return this.segmentInterval;
    }

    int compareSegmentedKeys(Bytes cacheKey, Bytes storeKey) {
        long storeSegmentId = this.segmentId(storeKey);
        long cacheSegmentId = ByteBuffer.wrap(cacheKey.get()).getLong();
        int segmentCompare = Long.compare(cacheSegmentId, storeSegmentId);
        if (segmentCompare == 0) {
            byte[] cacheKeyBytes = cacheKey.get();
            byte[] storeKeyBytes = storeKey.get();
            return Bytes.BYTES_LEXICO_COMPARATOR.compare(cacheKeyBytes, 8, cacheKeyBytes.length - 8, storeKeyBytes, 0, storeKeyBytes.length);
        }
        return segmentCompare;
    }
}

