/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import jakarta.persistence.criteria.Nulls;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.query.SortDirection;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class SelfRenderingOrderingExpression
extends SelfRenderingSqlFragmentExpression
implements OrderingExpression {
    public SelfRenderingOrderingExpression(String expression) {
        super(expression);
    }

    @Override
    public Expression resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        return this;
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortDirection sortOrder, Nulls nullPrecedence, SqlAstCreationState creationState) {
        Expression expression = this.resolve(ast, tableGroup, modelPartName, creationState);
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        Expression sortExpression = OrderingExpression.applyCollation(expression, collation, creationState);
        ast.addSortSpecification(new SortSpecification(sortExpression, sortOrder, nullPrecedence));
    }

    @Override
    public String toDescriptiveText() {
        return "unknown";
    }
}

