/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public abstract class AbstractCteMutationHandler
extends AbstractMutationHandler {
    public static final String CTE_TABLE_IDENTIFIER = "id";
    private final DomainParameterXref domainParameterXref;
    private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> resolvedParameterMappingModelTypes;
    private final JdbcOperationQuerySelect select;

    public AbstractCteMutationHandler(CteTable cteTable, SqmDeleteOrUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(sqmStatement, sessionFactory);
        SessionFactoryImplementor factory = context.getSession().getFactory();
        EntityPersister entityDescriptor = this.getEntityDescriptor();
        String explicitDmlTargetAlias = ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias() == null ? "dml_target" : ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias();
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmStatement, (SqmRoot<?>)sqmStatement.getTarget(), explicitDmlTargetAlias, domainParameterXref, context.getQueryOptions(), context.getSession().getLoadQueryInfluencers(), context.getQueryParameterBindings(), factory.getSqlTranslationEngine());
        Map<SqmParameter<Object>, List<JdbcParameter>> parameterResolutions = domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmStatement.getWhereClause());
        sqmConverter.pruneTableGroupJoins();
        CteStatement idSelectCte = new CteStatement(cteTable, MatchingIdSelectionHelper.generateMatchingIdSelectStatement(entityDescriptor, sqmStatement, true, restriction, sqmConverter, context), CteMaterialization.MATERIALIZED);
        QuerySpec querySpec = new QuerySpec(true, 1);
        ArrayList domainResults = new ArrayList(1);
        SelectStatement statement = new SelectStatement(querySpec, domainResults);
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcOperationQuerySelect> translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)((Object)count)).getJdbcMapping()));
        querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, count));
        querySpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(idSelectCte.getCteTable().getTableExpression(), CTE_TABLE_IDENTIFIER)));
        statement.addCteStatement(idSelectCte);
        this.addDmlCtes(statement, idSelectCte, sqmConverter, parameterResolutions, factory);
        this.domainParameterXref = domainParameterXref;
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmConverter);
        this.resolvedParameterMappingModelTypes = sqmConverter.getSqmParameterMappingModelExpressibleResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return AbstractCteMutationHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        this.select = translator.translate(jdbcParameterBindings, context.getQueryOptions());
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        return SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return AbstractCteMutationHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
    }

    @Override
    public boolean dependsOnParameterBindings() {
        return this.select.dependsOnParameterBindings();
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        return this.select.isCompatibleWith(jdbcParameterBindings, queryOptions);
    }

    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        lockOptions.setLockMode(LockMode.WRITE);
        executionContext.getSession().autoFlushIfRequired(this.select.getAffectedTableNames());
        List list = executionContext.getSession().getFactory().getJdbcServices().getJdbcSelectExecutor().list(this.select, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.NONE, 1);
        return ((Number)list.get(0)).intValue();
    }

    protected JdbcOperationQuerySelect getSelect() {
        return this.select;
    }

    protected Expression createCountStar(SessionFactoryImplementor factory, MultiTableSqmMutationConverter sqmConverter) {
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmStar arg = new SqmStar(queryEngine.getCriteriaBuilder());
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("count").generateSqmExpression(arg, null, queryEngine).convertToSqlAst(sqmConverter);
    }

    protected Predicate createIdSubQueryPredicate(List<? extends Expression> lhsExpressions, CteStatement idSelectCte, SessionFactoryImplementor factory) {
        return this.createIdSubQueryPredicate(lhsExpressions, idSelectCte, null, factory);
    }

    protected Predicate createIdSubQueryPredicate(List<? extends Expression> lhsExpressions, CteStatement idSelectCte, ModelPart fkModelPart, SessionFactoryImplementor factory) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        QuerySpec subQuery = this.createIdSubQuery(idSelectCte, fkModelPart, factory);
        Expression lhs = lhsExpressions.size() == 1 ? lhsExpressions.get(0) : new SqlTuple(lhsExpressions, null);
        predicate.add(new InSubQueryPredicate(lhs, subQuery, false));
        return predicate;
    }

    protected QuerySpec createIdSubQuery(CteStatement idSelectCte, ModelPart fkModelPart, SessionFactoryImplementor factory) {
        NamedTableReference idSelectTableReference = new NamedTableReference(idSelectCte.getCteTable().getTableExpression(), CTE_TABLE_IDENTIFIER);
        List<CteColumn> cteColumns = idSelectCte.getCteTable().getCteColumns();
        int size = cteColumns.size();
        QuerySpec subQuery = new QuerySpec(false, 1);
        subQuery.getFromClause().addRoot(new CteTableGroup(idSelectTableReference));
        SelectClause subQuerySelectClause = subQuery.getSelectClause();
        if (fkModelPart == null) {
            for (int i = 0; i < size; ++i) {
                CteColumn cteColumn = cteColumns.get(i);
                subQuerySelectClause.addSqlSelection(new SqlSelectionImpl(i, new ColumnReference(idSelectTableReference, cteColumn.getColumnExpression(), cteColumn.getJdbcMapping())));
            }
        } else {
            fkModelPart.forEachSelectable((selectionIndex, selectableMapping) -> subQuerySelectClause.addSqlSelection(new SqlSelectionImpl(selectionIndex, new ColumnReference(idSelectTableReference, selectableMapping.getSelectionExpression(), selectableMapping.getJdbcMapping()))));
        }
        return subQuery;
    }

    protected abstract void addDmlCtes(CteContainer var1, CteStatement var2, MultiTableSqmMutationConverter var3, Map<SqmParameter<?>, List<JdbcParameter>> var4, SessionFactoryImplementor var5);

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    protected abstract String getCteTableName(String var1);
}

