/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSingularValuedJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmCorrelatedEntityJoin<L, R>
extends SqmEntityJoin<L, R>
implements SqmCorrelatedSingularValuedJoin<L, R> {
    private final SqmCorrelatedRootJoin<L> correlatedRootJoin;
    private final SqmEntityJoin<L, R> correlationParent;

    public SqmCorrelatedEntityJoin(SqmEntityJoin<L, R> correlationParent) {
        super(correlationParent.getNavigablePath(), correlationParent.getReferencedPathSource(), correlationParent.getExplicitAlias(), SqmJoinType.INNER, correlationParent.getRoot());
        this.correlatedRootJoin = SqmCorrelatedRootJoin.create(correlationParent, this);
        this.correlationParent = correlationParent;
    }

    public SqmCorrelatedEntityJoin(EntityDomainType<R> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<L> sqmRoot, SqmCorrelatedRootJoin<L> correlatedRootJoin, SqmEntityJoin<L, R> correlationParent) {
        super(correlationParent.getNavigablePath(), joinedEntityDescriptor, alias, joinType, sqmRoot);
        this.correlatedRootJoin = correlatedRootJoin;
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmCorrelatedEntityJoin<L, R> copy(SqmCopyContext context) {
        SqmCorrelatedEntityJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedEntityJoin<L, R> path = context.registerCopy(this, new SqmCorrelatedEntityJoin<L, R>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.getRoot().copy(context), this.correlatedRootJoin.copy(context), this.correlationParent.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getCorrelatedRoot();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelatedEntityJoin(this);
    }

    @Override
    public SqmEntityJoin<L, R> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<R> getWrappedPath() {
        return this.correlationParent;
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<L> getCorrelatedRoot() {
        return this.correlatedRootJoin;
    }

    @Override
    public SqmCorrelatedEntityJoin<L, R> createCorrelation() {
        return new SqmCorrelatedEntityJoin<L, R>(this);
    }

    @Override
    public SqmCorrelatedEntityJoin<L, R> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmCorrelatedEntityJoin<L, R>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot)pathRegistry.findFromByPath(this.getRoot().getNavigablePath()), (SqmCorrelatedRootJoin)pathRegistry.findFromByPath(this.correlatedRootJoin.getNavigablePath()), (SqmEntityJoin)pathRegistry.findFromByPath(this.correlationParent.getNavigablePath()));
    }
}

