/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.reactive.common.runtime.ArcBeanFactory;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import org.jboss.resteasy.reactive.common.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.spi.BeanFactory;

@Recorder
public class ResteasyReactiveCommonRecorder {
    private static final Map<String, Class<?>> primitiveTypes = Map.of(Byte.TYPE.getName(), Byte.TYPE, Boolean.TYPE.getName(), Boolean.TYPE, Character.TYPE.getName(), Character.TYPE, Short.TYPE.getName(), Short.TYPE, Integer.TYPE.getName(), Integer.TYPE, Float.TYPE.getName(), Float.TYPE, Double.TYPE.getName(), Double.TYPE, Long.TYPE.getName(), Long.TYPE);

    public <T> BeanFactory<T> factory(String targetClass, BeanContainer beanContainer) {
        return new ArcBeanFactory<T>(ResteasyReactiveCommonRecorder.loadClass(targetClass), beanContainer);
    }

    public void registerWriter(Serialisers serialisers, String entityClassName, ResourceWriter writer) {
        serialisers.addWriter(ResteasyReactiveCommonRecorder.loadClass(entityClassName), writer);
    }

    public void registerReader(Serialisers serialisers, String entityClassName, ResourceReader reader) {
        serialisers.addReader(ResteasyReactiveCommonRecorder.loadClass(entityClassName), reader);
    }

    protected static <T> Class<T> loadClass(String name) {
        if (primitiveTypes.containsKey(name)) {
            return primitiveTypes.get(name);
        }
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setupBlockingOperationSupport() {
        BlockingOperationSupport.setIoThreadDetector((BlockingOperationSupport.IOThreadDetector)new BlockingOperationSupport.IOThreadDetector(){

            public boolean isBlockingAllowed() {
                return BlockingOperationControl.isBlockingAllowed();
            }
        });
    }
}

