/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultWorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathTree;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public interface WorkspaceModule {
    public static Mutable builder() {
        return DefaultWorkspaceModule.builder();
    }

    public WorkspaceModuleId getId();

    public File getModuleDir();

    public File getBuildDir();

    public Collection<String> getSourceClassifiers();

    public boolean hasSources(String var1);

    public ArtifactSources getSources(String var1);

    default public boolean hasMainSources() {
        return this.hasSources("");
    }

    default public boolean hasTestSources() {
        return this.hasSources("tests");
    }

    default public ArtifactSources getMainSources() {
        return this.getSources("");
    }

    default public ArtifactSources getTestSources() {
        return this.getSources("tests");
    }

    public PathCollection getBuildFiles();

    default public PathTree getContentTree(String classifier) {
        ArtifactSources artifactSources = this.getSources(classifier);
        return artifactSources == null || !artifactSources.isOutputAvailable() ? EmptyPathTree.getInstance() : artifactSources.getOutputTree();
    }

    public Collection<Dependency> getDirectDependencyConstraints();

    public Collection<Dependency> getDirectDependencies();

    public Collection<String> getTestClasspathDependencyExclusions();

    public Collection<String> getAdditionalTestClasspathElements();

    public WorkspaceModule getParent();

    public Mutable mutable();

    public static interface Mutable
    extends WorkspaceModule {
        public Mutable setModuleId(WorkspaceModuleId var1);

        public Mutable setModuleDir(Path var1);

        public Mutable setBuildDir(Path var1);

        public Mutable setBuildFile(Path var1);

        public Mutable addDependencyConstraint(Dependency var1);

        public Mutable setDependencyConstraints(List<Dependency> var1);

        public Mutable addDependency(Dependency var1);

        public Mutable setDependencies(List<Dependency> var1);

        public Mutable addArtifactSources(ArtifactSources var1);

        public Mutable setTestClasspathDependencyExclusions(Collection<String> var1);

        public Mutable setAdditionalTestClasspathElements(Collection<String> var1);

        public Mutable setParent(WorkspaceModule var1);

        public WorkspaceModule build();

        @Override
        default public Mutable mutable() {
            return this;
        }
    }
}

