/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.transform;

import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.translate.Transform;

public class RandomResizedCrop
implements Transform {
    private int width;
    private int height;
    private double minAreaScale;
    private double maxAreaScale;
    private double minAspectRatio;
    private double maxAspectRatio;

    public RandomResizedCrop(int width, int height, double minAreaScale, double maxAreaScale, double minAspectRatio, double maxAspectRatio) {
        this.width = width;
        this.height = height;
        this.minAreaScale = minAreaScale;
        this.maxAreaScale = maxAreaScale;
        this.minAspectRatio = minAspectRatio;
        this.maxAspectRatio = maxAspectRatio;
    }

    public RandomResizedCrop(int width, int height) {
        this.width = width;
        this.height = height;
        this.minAreaScale = 0.08;
        this.maxAreaScale = 1.0;
        this.minAspectRatio = 0.75;
        this.maxAspectRatio = 1.3333333333333333;
    }

    @Override
    public NDArray transform(NDArray array) {
        return NDImageUtils.randomResizedCrop(array, this.width, this.height, this.minAreaScale, this.maxAreaScale, this.minAspectRatio, this.maxAspectRatio);
    }
}

