/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public final class TimeScaleDailyHideClosed
implements TimeScale {
    private final double cellWidth;
    private final Day startingDay;
    private Day biggest;
    private final OpenClose openClose;
    private final Map<Day, Integer> startingInt = new HashMap<Day, Integer>();

    public TimeScaleDailyHideClosed(double size, Day startingDay, double scale, OpenClose openClose) {
        this.cellWidth = size * scale;
        this.startingDay = startingDay;
        this.biggest = startingDay;
        this.openClose = openClose;
        this.startingInt.put(startingDay, 0);
    }

    @Override
    public double getStartingPosition(Day instant) {
        if (instant.compareTo(this.startingDay) < 0) {
            throw new IllegalArgumentException();
        }
        this.computeUpTo(instant);
        return (double)this.startingInt.get(instant).intValue() * this.cellWidth;
    }

    private void computeUpTo(Day dest) {
        if (dest.compareTo(this.biggest) <= 0) {
            return;
        }
        Day i = this.biggest;
        int current = this.startingInt.get(i);
        do {
            if (this.getWidth(i) > 0.0) {
                ++current;
            }
            i = i.increment();
            this.startingInt.put(i, current);
        } while (i.compareTo(dest) < 0);
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.getStartingPosition(instant) + this.getWidth(instant);
    }

    @Override
    public double getWidth(Day instant) {
        if (this.openClose.isClosed(instant)) {
            return 0.0;
        }
        return this.cellWidth;
    }

    @Override
    public boolean isBreaking(Day instant) {
        return true;
    }
}

