/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.emoji.SvgNanoParser;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandSpriteSvgMultiline
extends CommandMultilines2<TitledDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("(.*\\</svg\\>)$"));
    public static final CommandSpriteSvgMultiline ME = new CommandSpriteSvgMultiline();

    private CommandSpriteSvgMultiline() {
        super(CommandSpriteSvgMultiline.getRegexConcat(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH, END);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteSvgMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf(1, "NAME", "([-%pLN_]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "SVGSTART", "(\\<svg\\b.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram system, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String svgStart = line0.get("SVGSTART", 0);
        lines = lines.subExtract(1, 0);
        StringBuilder svg = new StringBuilder(svgStart);
        for (StringLocated sl : lines) {
            svg.append(sl.getString());
        }
        SvgNanoParser nanoParser = new SvgNanoParser(svg.toString());
        system.addSprite(line0.get("NAME", 0), nanoParser);
        return CommandExecutionResult.ok();
    }
}

