/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public class ResourceDrawHistogram
implements ResourceDraw {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final Day min;
    private final Day max;
    private final GanttDiagram gantt;

    public ResourceDrawHistogram(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Day min, Day max) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min;
        this.max = max;
        this.gantt = gantt;
    }

    private UGraphic withColor(UGraphic ug, HColor color) {
        return ug.apply(color).apply(color.bg());
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Day i = this.min;
        while (i.compareTo(this.max) <= 0) {
            int load = this.gantt.getLoadForResource(this.res, i);
            double startingPosition = this.timeScale.getStartingPosition(i);
            double width = this.timeScale.getStartingPosition(i.increment()) - startingPosition;
            double height = Math.min(30.0, (double)load * 16.0 / 100.0);
            if (height > 0.0 && width > 0.0) {
                URectangle rect = URectangle.build(width, height);
                HColor color = load > 100 ? HColors.RED : HColors.GRAY;
                this.withColor(ug.apply(new UTranslate(startingPosition, this.getHeight(stringBounder) - rect.getHeight())), color).draw(rect);
            }
            i = i.increment();
        }
        TextBlock title = Display.getWithNewlines(this.gantt.getPragma(), this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = ULine.hline(this.timeScale.getEndingPosition(this.max) - this.timeScale.getStartingPosition(this.min));
        ug.apply(HColors.BLACK).draw(line);
        ug.apply(HColors.GRAY).apply(UTranslate.dy(16.0)).draw(line);
        ug.apply(HColors.BLACK).apply(UTranslate.dy(this.getHeight(stringBounder))).draw(line);
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HColors.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HColor color) {
        UFont font = UFont.serif(size);
        return FontConfiguration.create(font, color, color, null);
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 32.0;
    }

    @Override
    public final double getY() {
        return this.y;
    }
}

