/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XLine2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockEmpty;
import net.sourceforge.plantuml.sdot.SmetanaEdge;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.CornerParam;
import net.sourceforge.plantuml.skin.SkinParamBackcolored;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;

public class EntityImageNote
extends AbstractEntityImage
implements Stencil {
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final double shadowing;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final Style style;
    private final TextBlock textBlock;
    private SvekEdge opaleLine;
    private Link opaleLink;
    private SvekNode node;
    private SvekNode other;
    private Map<Link, SmetanaEdge> smetanaPathes;

    public EntityImageNote(Entity entity) {
        super(entity);
        Display strings = entity.getDisplay();
        this.style = this.getDefaultStyleDefinition(this.getStyleName()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
        this.borderColor = this.style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        this.shadowing = this.style.getShadowing();
        FontConfiguration fontConfiguration = this.style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment horizontalAlignment = this.style.getHorizontalAlignment();
        this.textBlock = strings.size() == 1 && strings.get(0).length() == 0 ? new TextBlockEmpty() : BodyFactory.create3(strings, this.getSkinParam(), horizontalAlignment, fontConfiguration, this.style.wrapWidth(), this.style);
    }

    private static ISkinParam getISkinParam(ISkinParam skinParam, Entity entity) {
        if (entity.getColors() != null) {
            return entity.getColors().mute(skinParam);
        }
        return skinParam;
    }

    static ISkinParam getSkin(ISkinParam skinParam, Entity entity) {
        Stereotype stereotype = entity.getStereotype();
        HColor back = entity.getColors().getColor(ColorType.BACK);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        back = EntityImageNote.getColorStatic(skinParam, ColorParam.noteBackground, stereotype);
        if (back != null) {
            return new SkinParamBackcolored(skinParam, back);
        }
        return skinParam;
    }

    private static HColor getColorStatic(ISkinParam skinParam, ColorParam colorParam, Stereotype stereo) {
        Rose rose = new Rose();
        return rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder);
        return result;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    private XDimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        return textBlock.calculateDimension(stringBounder);
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        XDimension2D size = this.getSize(stringBounder, textBlock);
        return size.getHeight() + 10.0;
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        XDimension2D size = this.getSize(stringBounder, textBlock);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getPreferredHeight(stringBounder);
        double width = this.getPreferredWidth(stringBounder);
        return new XDimension2D(width, height);
    }

    private StyleSignature getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note).withTOBECHANGED(this.getStereo());
    }

    @Override
    public final void drawU(UGraphic ug) {
        Url url = this.getEntity().getUrl99();
        UGroup group = new UGroup(this.getEntity().getLocation());
        group.put(UGroupType.CLASS, "entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        if (url != null) {
            ug.startUrl(url);
        }
        UGraphic ug2 = UGraphicStencil.create(ug, this, UStroke.simple());
        if (this.opaleLink != null) {
            StringBounder stringBounder = ug.getStringBounder();
            SmetanaEdge smetanaEdged = this.smetanaPathes.get(this.opaleLink);
            UTranslate move = new UTranslate(-this.node.getMinX(), -this.node.getMinY());
            XPoint2D startPoint = move.getTranslated(smetanaEdged.getStartPoint());
            XPoint2D endPoint = move.getTranslated(smetanaEdged.getEndPoint());
            UTranslate force1 = this.getMagneticBorder().getForceAt(stringBounder, smetanaEdged.getStartPoint());
            UTranslate force2 = this.other.getMagneticBorder().getForceAt(stringBounder, smetanaEdged.getEndPoint());
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            XPoint2D center = new XPoint2D(textWidth / 2.0, textHeight / 2.0);
            XPoint2D pp1 = force2.getTranslated(startPoint);
            XPoint2D pp2 = force1.getTranslated(endPoint);
            if (pp1.distance(center) < pp2.distance(center)) {
                pp1 = force1.getTranslated(endPoint);
                pp2 = force2.getTranslated(startPoint);
            }
            Direction strategy = this.getOpaleStrategy(textWidth, textHeight, pp2);
            Opale opale = new Opale(this.shadowing, this.borderColor, this.noteBackgroundColor, this.textBlock, true, this.getStroke());
            opale.setRoundCorner(this.getRoundCorner());
            opale.setOpale(strategy, pp2, pp1);
            UGraphic stroked = this.applyStroke(ug2);
            opale.drawU(Colors.applyStroke(stroked, this.getEntity().getColors()));
        } else if (this.opaleLine == null || !this.opaleLine.isOpale()) {
            this.drawNormal(ug2);
        } else {
            StringBounder stringBounder = ug.getStringBounder();
            DotPath path = this.opaleLine.getDotPath();
            UTranslate force1 = this.getMagneticBorder().getForceAt(stringBounder, path.getStartPoint());
            UTranslate force2 = this.other.getMagneticBorder().getForceAt(stringBounder, path.getEndPoint());
            path.moveDelta(-this.node.getMinX(), -this.node.getMinY());
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            XPoint2D center = new XPoint2D(textWidth / 2.0, textHeight / 2.0);
            if (path.getStartPoint().distance(center) > path.getEndPoint().distance(center)) {
                path = path.reverse();
            }
            Direction strategy = this.getOpaleStrategy(textWidth, textHeight, path.getStartPoint());
            XPoint2D pp1 = force1.getTranslated(path.getStartPoint());
            XPoint2D pp2 = force2.getTranslated(path.getEndPoint());
            Opale opale = new Opale(this.shadowing, this.borderColor, this.noteBackgroundColor, this.textBlock, true, this.getStroke());
            opale.setRoundCorner(this.getRoundCorner());
            opale.setOpale(strategy, pp1, pp2);
            UGraphic stroked = this.applyStroke(ug2);
            opale.drawU(Colors.applyStroke(stroked, this.getEntity().getColors()));
        }
        if (url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private double getRoundCorner() {
        return this.getSkinParam().getRoundCorner(CornerParam.DEFAULT, null);
    }

    private void drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UPath polygon = Opale.getPolygonNormal(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.getRoundCorner());
        polygon.setDeltaShadow(this.shadowing);
        ug = ug.apply(this.noteBackgroundColor.bg()).apply(this.borderColor);
        UGraphic stroked = this.applyStroke(ug);
        stroked.draw(polygon);
        ug.draw(Opale.getCorner(this.getTextWidth(stringBounder), this.getRoundCorner()));
        this.getTextBlock().drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UGraphic applyStroke(UGraphic ug) {
        return ug.apply(this.style.getStroke());
    }

    private UStroke getStroke() {
        return this.style.getStroke();
    }

    private Direction getOpaleStrategy(double width, double height, XPoint2D pt) {
        double d1 = EntityImageNote.getOrthoDistance(new XLine2D(width, 0.0, width, height), pt);
        double d2 = EntityImageNote.getOrthoDistance(new XLine2D(0.0, height, width, height), pt);
        double d3 = EntityImageNote.getOrthoDistance(new XLine2D(0.0, 0.0, 0.0, height), pt);
        double d4 = EntityImageNote.getOrthoDistance(new XLine2D(0.0, 0.0, width, 0.0), pt);
        if (d3 <= d1 && d3 <= d2 && d3 <= d4) {
            return Direction.LEFT;
        }
        if (d1 <= d2 && d1 <= d3 && d1 <= d4) {
            return Direction.RIGHT;
        }
        if (d4 <= d1 && d4 <= d2 && d4 <= d3) {
            return Direction.UP;
        }
        if (d2 <= d1 && d2 <= d3 && d2 <= d4) {
            return Direction.DOWN;
        }
        return null;
    }

    private static double getOrthoDistance(XLine2D seg, XPoint2D pt) {
        if (EntityImageNote.isHorizontal(seg)) {
            return Math.abs(seg.getP1().getY() - pt.getY());
        }
        if (EntityImageNote.isVertical(seg)) {
            return Math.abs(seg.getP1().getX() - pt.getX());
        }
        throw new IllegalArgumentException();
    }

    private static boolean isHorizontal(XLine2D seg) {
        return seg.getP1().getY() == seg.getP2().getY();
    }

    private static boolean isVertical(XLine2D seg) {
        return seg.getP1().getX() == seg.getP2().getX();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public void setOpaleLine(SvekEdge line, SvekNode node, SvekNode other) {
        this.opaleLine = line;
        this.node = node;
        this.other = Objects.requireNonNull(other);
    }

    public void setOpaleLink(Link link, SvekNode node, SvekNode other, Map<Link, SmetanaEdge> edges) {
        this.opaleLink = link;
        this.node = node;
        this.other = Objects.requireNonNull(other);
        this.smetanaPathes = edges;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

