/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.CaseMode;

public class CharSet {
    private final CaseMode mode = CaseMode.CASE_INSENSITIVE;
    private long mask1 = 0L;
    private long mask2 = 0L;

    public void addChar(char ch) {
        if (this.mode == CaseMode.CASE_INSENSITIVE) {
            ch = CaseMode.ensureLowercase(ch);
        }
        int offset = this.getOffset(ch);
        if (ch < ' ' || ch > '\u0080') {
            throw new IllegalArgumentException("Bad char : " + ch);
        }
        if (offset < 64) {
            this.mask1 |= 1L << offset;
        } else {
            this.mask2 |= 1L << offset - 64;
        }
    }

    public void addRange(char start, char end) {
        if (start > end) {
            throw new IllegalArgumentException("Invalid range: '" + start + "' is greater than '" + end + "'.");
        }
        if (start < ' ' || end > '\u0080') {
            throw new IllegalArgumentException("Characters must be in the range 32 to 128.");
        }
        if (this.mode == CaseMode.CASE_INSENSITIVE) {
            start = CaseMode.ensureLowercase(start);
            end = CaseMode.ensureLowercase(end);
        }
        int startOffset = start - 32;
        int endOffset = end - 32;
        if (endOffset < 64) {
            int length = endOffset - startOffset + 1;
            long rangeMask = (length == 64 ? -1L : (1L << length) - 1L) << startOffset;
            this.mask1 |= rangeMask;
        } else if (startOffset >= 64) {
            int adjustedStart = startOffset - 64;
            int adjustedEnd = endOffset - 64;
            int length = adjustedEnd - adjustedStart + 1;
            long rangeMask = (1L << length) - 1L << adjustedStart;
            this.mask2 |= rangeMask;
        } else {
            int length1 = 64 - startOffset;
            long maskPart1 = (length1 == 64 ? -1L : (1L << length1) - 1L) << startOffset;
            this.mask1 |= maskPart1;
            int adjustedEnd = endOffset - 64;
            int length2 = adjustedEnd + 1;
            long maskPart2 = (1L << length2) - 1L;
            this.mask2 |= maskPart2;
        }
    }

    public boolean contains(char ch) {
        int offset;
        if (this.mode == CaseMode.CASE_INSENSITIVE) {
            ch = CaseMode.ensureLowercase(ch);
        }
        if ((offset = this.getOffset(ch)) > 128) {
            return false;
        }
        if (offset < 64) {
            return (this.mask1 & 1L << offset) != 0L;
        }
        return (this.mask2 & 1L << offset - 64) != 0L;
    }

    private int getOffset(char ch) {
        return ch - 32;
    }
}

