/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PanelsNoLeft;

public class PanelsClock
extends PanelsNoLeft {
    private final int period;
    private final int pulse;
    private final int offset;

    public PanelsClock(TimingRuler ruler, ISkinParam skinParam, int suggestedHeight, Style style, int period, int pulse, int offset, List<TimeConstraint> constraints) {
        super(ruler, skinParam, suggestedHeight, style, null, constraints);
        this.period = period;
        this.pulse = pulse;
        this.offset = offset;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.suggestedHeight;
    }

    private double getLineHeight(StringBounder stringBounder) {
        return (double)this.suggestedHeight - 16.0;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawRightPanel(UGraphic ug) {
        ug = this.getContext().apply(ug);
        ULine vline = ULine.vline(this.getLineHeight(ug.getStringBounder()));
        ug = ug.apply(UTranslate.dy(8.0));
        double value = 0.0;
        if (this.offset != 0) {
            this.drawHorizontalBetweenTimes(ug.apply(UTranslate.dy(vline.getDY())), value, this.offset);
            value += (double)this.offset;
        }
        if (this.xOfTime(value) > this.ruler.getWidth()) {
            return;
        }
        this.drawVline(ug, this.xOfTime(value), 0.0, vline);
        double vpulse = this.pulse == 0 ? (double)this.period / 2.0 : (double)this.pulse;
        double remain = (double)this.period - vpulse;
        for (int i = 0; i < 1000; ++i) {
            this.drawHorizontalBetweenTimes(ug, value, value + vpulse);
            value += vpulse;
            if (this.xOfTime(value) > this.ruler.getWidth()) {
                return;
            }
            this.drawVline(ug, this.xOfTime(value), 0.0, vline);
            this.drawHorizontalBetweenTimes(ug.apply(UTranslate.dy(vline.getDY())), value, value + remain);
            value += remain;
            if (this.xOfTime(value) > this.ruler.getWidth()) {
                return;
            }
            this.drawVline(ug, this.xOfTime(value), 0.0, vline);
        }
    }
}

