/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.personalization.session.ElementSessionFactorsStorage;
import com.intellij.completion.ml.personalization.session.LookupSessionFactorsStorage;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.openapi.util.registry.Registry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003*+,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007J*\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u001eH\u0002J;\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000e\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u0002H 2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001a0#H\u0002\u00a2\u0006\u0002\u0010$J&\u0010%\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00052\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00010'H\u0002J&\u0010(\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010\u00010'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils;", "", "<init>", "()V", "SESSION_FACTOR_PREFIX", "", "lookupFactors", "", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "elementFactors", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "shouldUseSessionFactors", "", "updateSessionFactors", "", "lookupStorage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "items", "Lcom/intellij/codeInsight/lookup/LookupElement;", "saveElementFactorsTo", "", "map", "", "Lcom/intellij/completion/ml/storage/LookupStorage;", "lookupElement", "name", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "getName", "(Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;)Ljava/lang/String;", "calculateLookupFactors", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "calculateFactors", "S", "storage", "factors", "", "(Ljava/lang/Object;Ljava/lang/Iterable;)Ljava/util/Map;", "lookupFactor", "extractor", "Lkotlin/Function1;", "elementFactor", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "SessionLookupFactor", "ElementFactor", "SessionFactor", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nSessionFactorsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionFactorsUtils.kt\ncom/intellij/completion/ml/personalization/session/SessionFactorsUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1878#2,3:104\n*S KotlinDebug\n*F\n+ 1 SessionFactorsUtils.kt\ncom/intellij/completion/ml/personalization/session/SessionFactorsUtils\n*L\n43#1:104,3\n*E\n"})
public final class SessionFactorsUtils {
    @NotNull
    public static final SessionFactorsUtils INSTANCE = new SessionFactorsUtils();
    @NotNull
    private static final String SESSION_FACTOR_PREFIX = "session_";
    @NotNull
    private static final List<SessionFactor.LookupBased> lookupFactors;
    @NotNull
    private static final List<SessionFactor.LookupElementBased> elementFactors;

    private SessionFactorsUtils() {
    }

    public final boolean shouldUseSessionFactors() {
        return Registry.Companion.is("completion.ml.enable.session.factors");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> updateSessionFactors(@NotNull MutableLookupStorage lookupStorage, @NotNull List<? extends LookupElement> items) {
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (!this.shouldUseSessionFactors()) {
            return MapsKt.emptyMap();
        }
        LookupSessionFactorsStorage sessionFactors = lookupStorage.getSessionFactors();
        sessionFactors.fireSortingPerforming(items.size());
        Map<String, Object> lookupFactors = this.calculateLookupFactors(sessionFactors);
        lookupStorage.getSessionFactors().updateLastUsedFactors(lookupFactors);
        Iterable $this$forEachIndexed$iv = items;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LookupElement lookupElement = (LookupElement)item$iv;
            int i = n;
            boolean bl = false;
            ElementSessionFactorsStorage factorsStorage = lookupStorage.getItemStorage(LookupElementExtensionsKt.idString((LookupElement)item)).getSessionFactors();
            factorsStorage.computeSessionFactors(i, (Function1<? super ElementSessionFactorsStorage, ? extends Map<String, ? extends Object>>)((Function1)SessionFactorsUtils::updateSessionFactors$lambda$17$lambda$16));
        }
        return lookupFactors;
    }

    public final void saveElementFactorsTo(@NotNull Map<String, Object> map, @NotNull LookupStorage lookupStorage, @NotNull LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        ElementSessionFactorsStorage factorsStorage = lookupStorage.getItemStorage(LookupElementExtensionsKt.idString(lookupElement)).getSessionFactors();
        map.putAll(factorsStorage.lastUsedElementFactors());
    }

    private final String getName(SessionFactor<?> $this$name) {
        return SESSION_FACTOR_PREFIX + $this$name.getSimpleName();
    }

    private final Map<String, Object> calculateLookupFactors(LookupSessionFactorsStorage lookupStorage) {
        return this.calculateFactors(lookupStorage, (Iterable)lookupFactors);
    }

    private final <S> Map<String, Object> calculateFactors(S storage, Iterable<? extends SessionFactor<S>> factors) {
        Map result = new LinkedHashMap();
        for (SessionFactor<S> factor : factors) {
            boolean bl;
            String factorName = this.getName(factor);
            boolean bl2 = bl = !result.containsKey(factorName);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object factorValue = factor.getValue(storage);
            if (factorValue == null) continue;
            result.put(factorName, factorValue);
        }
        return result;
    }

    private final SessionFactor.LookupBased lookupFactor(String name, Function1<? super LookupSessionFactorsStorage, ? extends Object> extractor) {
        return new SessionLookupFactor(name, extractor);
    }

    private final SessionFactor.LookupElementBased elementFactor(String name, Function1<? super ElementSessionFactorsStorage, ? extends Object> extractor) {
        return new ElementFactor(name, extractor);
    }

    private static final Object lookupFactors$lambda$0(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVisibleSize();
    }

    private static final Object lookupFactors$lambda$1(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSortingOrder();
    }

    private static final Object lookupFactors$lambda$2(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return System.currentTimeMillis() - it.getStartedTimestamp();
    }

    private static final Object lookupFactors$lambda$3(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getTotalQueriesCount();
    }

    private static final Object lookupFactors$lambda$4(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getUniqueQueriesCount();
    }

    private static final Object lookupFactors$lambda$5(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getCurrentQueryFrequency();
    }

    private static final Object lookupFactors$lambda$6(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getDurations().getCurrentQueryDuration();
    }

    private static final Object lookupFactors$lambda$7(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getDurations().getAverageQueryDuration();
    }

    private static final Object lookupFactors$lambda$8(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getDurations().getMinQueryDuration();
    }

    private static final Object lookupFactors$lambda$9(LookupSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTracker().getDurations().getMaxQueryDuration();
    }

    private static final Object elementFactors$lambda$10(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVisiblePosition();
    }

    private static final Object elementFactors$lambda$11(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSelectionTracker().getTimesInSelection();
    }

    private static final Object elementFactors$lambda$12(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSelectionTracker().getTotalTimeInSelection();
    }

    private static final Object elementFactors$lambda$13(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSelectionTracker().getAverageTimeInSelection();
    }

    private static final Object elementFactors$lambda$14(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSelectionTracker().getMaxTimeInSelection();
    }

    private static final Object elementFactors$lambda$15(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSelectionTracker().getMinTimeInSelection();
    }

    private static final Map updateSessionFactors$lambda$17$lambda$16(ElementSessionFactorsStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.calculateFactors(it, (Iterable)elementFactors);
    }

    static {
        Object[] objectArray = new SessionFactor.LookupBased[]{INSTANCE.lookupFactor("visible_size", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$0)), INSTANCE.lookupFactor("sorting_order", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$1)), INSTANCE.lookupFactor("duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$2)), INSTANCE.lookupFactor("query_number", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$3)), INSTANCE.lookupFactor("unique_queries", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$4)), INSTANCE.lookupFactor("current_query_frequency", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$5)), INSTANCE.lookupFactor("current_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$6)), INSTANCE.lookupFactor("average_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$7)), INSTANCE.lookupFactor("min_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$8)), INSTANCE.lookupFactor("max_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::lookupFactors$lambda$9))};
        lookupFactors = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new SessionFactor.LookupElementBased[]{INSTANCE.elementFactor("visible_position", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$10)), INSTANCE.elementFactor("times_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$11)), INSTANCE.elementFactor("total_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$12)), INSTANCE.elementFactor("average_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$13)), INSTANCE.elementFactor("max_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$14)), INSTANCE.elementFactor("min_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)SessionFactorsUtils::elementFactors$lambda$15))};
        elementFactors = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$ElementFactor;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "simpleName", "", "valueExtractor", "Lkotlin/Function1;", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "intellij.completionMlRanking"})
    private static final class ElementFactor
    implements SessionFactor.LookupElementBased {
        @NotNull
        private final String simpleName;
        @NotNull
        private final Function1<ElementSessionFactorsStorage, Object> valueExtractor;

        public ElementFactor(@NotNull String simpleName, @NotNull Function1<? super ElementSessionFactorsStorage, ? extends Object> valueExtractor) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter(valueExtractor, (String)"valueExtractor");
            this.simpleName = simpleName;
            this.valueExtractor = valueExtractor;
        }

        @Override
        @NotNull
        public String getSimpleName() {
            return this.simpleName;
        }

        @Override
        @Nullable
        public Object getValue(@NotNull ElementSessionFactorsStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.valueExtractor.invoke((Object)storage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\n\u000bJ\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "T", "", "simpleName", "", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "(Ljava/lang/Object;)Ljava/lang/Object;", "LookupBased", "LookupElementBased", "intellij.completionMlRanking"})
    private static interface SessionFactor<T> {
        @NotNull
        public String getSimpleName();

        @Nullable
        public Object getValue(T var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0003\u00c0\u0006\u0001"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "intellij.completionMlRanking"})
        public static interface LookupBased
        extends SessionFactor<LookupSessionFactorsStorage> {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0003\u00c0\u0006\u0001"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "intellij.completionMlRanking"})
        public static interface LookupElementBased
        extends SessionFactor<ElementSessionFactorsStorage> {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionLookupFactor;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "simpleName", "", "valueExtractor", "Lkotlin/Function1;", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "intellij.completionMlRanking"})
    private static final class SessionLookupFactor
    implements SessionFactor.LookupBased {
        @NotNull
        private final String simpleName;
        @NotNull
        private final Function1<LookupSessionFactorsStorage, Object> valueExtractor;

        public SessionLookupFactor(@NotNull String simpleName, @NotNull Function1<? super LookupSessionFactorsStorage, ? extends Object> valueExtractor) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter(valueExtractor, (String)"valueExtractor");
            this.simpleName = simpleName;
            this.valueExtractor = valueExtractor;
        }

        @Override
        @NotNull
        public String getSimpleName() {
            return this.simpleName;
        }

        @Override
        @Nullable
        public Object getValue(@NotNull LookupSessionFactorsStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.valueExtractor.invoke((Object)storage);
        }
    }
}

