/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session.scraper;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0004H\u0016J\t\u0010\u000b\u001a\u00020\fH\u0096\u0001J\t\u0010\r\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/scraper/CommandEndMarkerListeningStringCollector;", "Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;", "delegate", "commandEndMarker", "", "onFound", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "buildText", "length", "", "newline", "write", "text", "Companion", "intellij.terminal"})
public final class CommandEndMarkerListeningStringCollector
implements StringCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringCollector delegate;
    @Nullable
    private final String commandEndMarker;
    @NotNull
    private final Function0<Unit> onFound;

    public CommandEndMarkerListeningStringCollector(@NotNull StringCollector delegate, @Nullable String commandEndMarker, @NotNull Function0<Unit> onFound) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(onFound, (String)"onFound");
        this.delegate = delegate;
        this.commandEndMarker = commandEndMarker;
        this.onFound = onFound;
    }

    @Override
    @NotNull
    public String buildText() {
        String text = this.delegate.buildText();
        if (this.commandEndMarker == null) {
            return text;
        }
        String trimmedText = ((Object)StringsKt.trimEnd((CharSequence)text)).toString();
        if (StringsKt.endsWith$default((String)trimmedText, (String)this.commandEndMarker, (boolean)false, (int)2, null)) {
            String outputText = StringsKt.dropLast((String)trimmedText, (int)this.commandEndMarker.length());
            this.onFound.invoke();
            return outputText;
        }
        int indexOfSuffix = Companion.indexOfSuffix(trimmedText, this.commandEndMarker, (Function1<? super Character, Boolean>)((Function1)CommandEndMarkerListeningStringCollector::buildText$lambda$0));
        if (indexOfSuffix >= 0) {
            String string = trimmedText.substring(0, indexOfSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String commandText = string;
            this.onFound.invoke();
            return commandText;
        }
        return text;
    }

    @Override
    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.delegate.write(text);
    }

    @Override
    public void newline() {
        this.delegate.newline();
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    private static final boolean buildText$lambda$0(char it) {
        return it == '\n';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/scraper/CommandEndMarkerListeningStringCollector$Companion;", "", "<init>", "()V", "indexOfSuffix", "", "text", "", "suffix", "ignoredCharacters", "Lkotlin/Function1;", "", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final int indexOfSuffix(@NotNull String text, @NotNull String suffix, @NotNull Function1<? super Character, Boolean> ignoredCharacters) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter(ignoredCharacters, (String)"ignoredCharacters");
            if (!(((CharSequence)suffix).length() > 0)) {
                throw new IllegalStateException("Check failed.");
            }
            if (text.length() < suffix.length()) {
                return -1;
            }
            int textInd = text.length();
            for (int suffixInd = suffix.length() - 1; -1 < suffixInd; --suffixInd) {
                --textInd;
                while (textInd >= 0 && ((Boolean)ignoredCharacters.invoke((Object)Character.valueOf(text.charAt(textInd)))).booleanValue()) {
                    --textInd;
                }
                if (textInd >= 0 && text.charAt(textInd) == suffix.charAt(suffixInd)) continue;
                return -1;
            }
            return textInd;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

