/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LoadFullValueCommand
extends AbstractFrameCommand {
    public static final String NEXT_VALUE_SEPARATOR = "__pydev_val__";
    @NotNull
    private final IPyDebugProcess myDebugProcess;
    @NotNull
    private final List<? extends PyFrameAccessor.PyAsyncValue<String>> myVars;

    public LoadFullValueCommand(@NotNull RemoteDebugger debugger, @NotNull String threadId, @NotNull String frameId, @NotNull List<? extends PyFrameAccessor.PyAsyncValue<String>> vars) {
        if (debugger == null) {
            LoadFullValueCommand.$$$reportNull$$$0(0);
        }
        if (threadId == null) {
            LoadFullValueCommand.$$$reportNull$$$0(1);
        }
        if (frameId == null) {
            LoadFullValueCommand.$$$reportNull$$$0(2);
        }
        if (vars == null) {
            LoadFullValueCommand.$$$reportNull$$$0(3);
        }
        super(debugger, 151, threadId, frameId);
        this.myDebugProcess = debugger.getDebugProcess();
        this.myVars = vars;
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            LoadFullValueCommand.$$$reportNull$$$0(4);
        }
        super.processResponse(response);
        try {
            List<PyDebugValue> debugValues = ProtocolParser.parseValues(response.getPayload(), this.myDebugProcess);
            for (int i = 0; i < debugValues.size(); ++i) {
                PyDebugValue pyDebugValue = debugValues.get(i);
                this.myVars.get(i).getCallback().ok(pyDebugValue.getValue());
            }
        }
        catch (Exception e) {
            for (PyFrameAccessor.PyAsyncValue<String> pyAsyncValue : this.myVars) {
                pyAsyncValue.getCallback().error(new PyDebuggerException(response.getPayload()));
            }
        }
    }

    @NotNull
    private String buildPayloadForVar(@NotNull PyDebugValue var) {
        if (var == null) {
            LoadFullValueCommand.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        String varName = GetVariableCommand.composeName(var);
        if (varName.contains("BY_ID")) {
            sb.append(this.getThreadId()).append(varName);
        } else {
            sb.append(varName);
        }
        String string = sb.toString();
        if (string == null) {
            LoadFullValueCommand.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        for (PyFrameAccessor.PyAsyncValue<String> pyAsyncValue : this.myVars) {
            PyDebugValue debugValue = pyAsyncValue.getDebugValue();
            payload.add("FRAME").add(this.buildPayloadForVar(debugValue)).add(NEXT_VALUE_SEPARATOR);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/LoadFullValueCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/LoadFullValueCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPayloadForVar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildPayloadForVar";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

