% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.filename-functions.R
\name{rk.get.tempfile.name}
\alias{rk.get.tempfile.name}
\alias{rk.get.workspace.url}
\alias{rk.get.output.html.file}
\alias{rk.set.output.html.file}
\alias{rk.tempdir}
\alias{rk.home}
\alias{rk.flush.output}
\title{RKWard file names}
\usage{
rk.get.tempfile.name(
  prefix = "image",
  extension = ".jpg",
  directory = dirname(rk.get.output.html.file())
)

rk.get.workspace.url()

rk.home(component = "home")

rk.get.output.html.file()

rk.set.output.html.file(
  x,
  additional.header.contents = getOption("rk.html.header.additions"),
  style = c("regular", "preview"),
  css = getOption("rk.output.css.file"),
  silent = FALSE
)

rk.flush.output(
  x = rk.get.output.html.file(),
  flush.images = TRUE,
  ask = TRUE,
  ...
)
}
\arguments{
\item{prefix}{a string, used as a filename prefix when saving images to the
output file. This is usually just a plain file name, but can also be a relative or absolute
path. Relative paths are resolved with the default output directory as base, absolute paths
are kept as is.}

\item{extension}{a string, used as a filename extension when saving images
to the output file}

\item{directory}{a string, The base directory for the file. If left empty, this will default to the
write directory of the current output file (usually "~.rkward)}

\item{component}{a string specifying the desired path. "home" (the default value) means to
return the generic data dir used by RKWard. "lib" means to return the directory where
the rkward R library is installed.}

\item{x}{a string, giving the filename of the of the output file}

\item{additional.header.contents}{NULL or an additional string to add to the HTML header section.
This could be scripts or additional CSS definitions, for example. Note that
\emph{nothing} will be added to the header, if the file already exists.}

\item{style}{Currently either "regular" or "preview". The latter omits table of contents and date.}

\item{css}{Local file name of CSS file to use, or NULL for no CSS file. The CSS file will be
placed next to x, with file name extension ".css". Only effective when initializing a
(non-existing) output file.}

\item{silent}{Set to true to avoid the output window being raised in the frontend.}

\item{flush.images}{If true, any images used in the output file will be deleted as well.}

\item{ask}{Logical: Whether to ask before flushing the output file.}

\item{...}{Further parameters passed to rk.set.output.html.file()}
}
\value{
\code{rk.get.tempfile.name}, \code{rk.get.output.html.file}, \code{rk.get.workspace.url}, and
  \code{rk.home} return a string while
  \code{rk.set.output.html.file} returns the \bold{previous} output html file.
}
\description{
In RKWard the output is saved as a html file which is located at "~/.rkward"
by default. (\bold{TODO}: make this platform free). The name of this html
file can be retrieved and set using \code{rk.get.output.html.file} and
\code{rk.set.output.html.file}. \code{rk.flush.output.html.file} will delete 
the current (or specified) html file, and re-initialize it.
}
\details{
\code{rk.get.tempfile.name} returns a non-existing filename inside the
specified directory (or the directory of the current output file, if the parameter is
omitted). The filename is returned as an absolute path,
but the relative path with respect to the base directory can be obtained via
\code{names()}. It is mainly used by \link{rk.graph.on} to
create filenames suitable for storing images in the output. The filenames of
the temporary files are of the form
"\code{prefix}\emph{xyz}.\code{extension}". \code{rk.get.tempfile.name} is
somewhat misnamed. For truly temporary files, \link{tempfile} is generally
more suitable.

\code{rk.tempdir} returns a directory suitable for storing rkward related
  temporary files. Almost the same as \code{tempdir()}, but the directory
  returned will be inside the configured RKWard data path  ("$HOME/.rkward", by default).

\code{rk.get.workspace.url} returns the url of workspace file which has been
loaded in RKWard, or NULL, if no workspace has been loaded. NOTE: This value
is note affected by running \code{load} in R, only by loading R workspaces
via the RKWard GUI.

\code{rk.home} returns the filename of the specified component similar to
\link{R.home}.
}
\examples{
\dontrun{
testfile.name <- rk.get.tempfile.name(prefix="test", extension=".txt")
testfile <- file(testfile.name)
cat("This is a test\n", file=testfile)
close(testfile)
unlink(testfile.name)

outfile <- rk.get.output.html.file()

rk.set.output.html.file("~/.rkward/another_file.html")
rk.header("Output on a different output file")
rk.show.html(rk.get.output.html.file())
rk.flush.output()
rk.set.output.html.file(outfile)
}
}
\seealso{
\url{rkward://page/rkward_output}, \link{tempfile}, \link{file},
  \link{rk.print}
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{IO}
\keyword{utilities}
