# -*- coding: utf-8 -*-
# Copyright 2024 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_vrf_address_family module
"""


class Vrf_address_familyArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_vrf_address_family module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "address_families": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {"type": "str", "choices": ["ipv4", "ipv6"]},
                        "safi": {
                            "type": "str",
                            "choices": ["multicast", "unicast"],
                        },
                        "bgp": {
                            "type": "dict",
                            "options": {
                                "next_hop": {
                                    "type": "dict",
                                    "options": {"loopback": {"type": "int"}},
                                },
                            },
                        },
                        "export": {
                            "type": "dict",
                            "options": {
                                "map": {"type": "str"},
                                "ipv4": {
                                    "type": "dict",
                                    "options": {
                                        "multicast": {
                                            "type": "dict",
                                            "options": {
                                                "prefix": {"type": "int"},
                                                "map": {"type": "str"},
                                            },
                                        },
                                        "unicast": {
                                            "type": "dict",
                                            "options": {
                                                "prefix": {"type": "int"},
                                                "map": {"type": "str"},
                                                "allow_evpn": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "import_config": {
                            "type": "dict",
                            "options": {
                                "map": {"type": "str"},
                                "ipv4": {
                                    "type": "dict",
                                    "options": {
                                        "multicast": {
                                            "type": "dict",
                                            "options": {
                                                "prefix": {"type": "int"},
                                                "map": {"type": "str"},
                                            },
                                        },
                                        "unicast": {
                                            "type": "dict",
                                            "options": {
                                                "limit": {"type": "int"},
                                                "map": {"type": "str"},
                                                "allow_evpn": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "inter_as_hybrid": {
                            "type": "dict",
                            "options": {
                                "csc": {
                                    "type": "dict",
                                    "options": {"next_hop": {"type": "str"}},
                                },
                                "next_hop": {"type": "str"},
                            },
                        },
                        "mdt": {
                            "type": "dict",
                            "options": {
                                "auto_discovery": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {
                                            "type": "dict",
                                            "options": {
                                                "inter_as": {
                                                    "type": "dict",
                                                    "options": {
                                                        "mdt_hello_enable": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                                "mdt_hello_enable": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                        "mldp": {"type": "bool"},
                                        "pim": {
                                            "type": "dict",
                                            "options": {
                                                "inter_as": {
                                                    "type": "dict",
                                                    "options": {
                                                        "mdt_hello_enable": {
                                                            "type": "bool",
                                                        },
                                                        "pim_tlv_announce": {
                                                            "type": "dict",
                                                            "options": {
                                                                "mdt_hello_enable": {
                                                                    "type": "bool",
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                                "mdt_hello_enable": {
                                                    "type": "bool",
                                                },
                                                "pim_tlv_announce": {
                                                    "type": "dict",
                                                    "options": {
                                                        "mdt_hello_enable": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "receiver_site": {"type": "bool"},
                                    },
                                },
                                "data": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {
                                            "type": "dict",
                                            "options": {
                                                "number": {"type": "int"},
                                                "immediate_switch": {
                                                    "type": "bool",
                                                },
                                                "list": {
                                                    "type": "dict",
                                                    "options": {
                                                        "access_list_number": {
                                                            "type": "int",
                                                        },
                                                        "access_list_name": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "list": {
                                            "type": "dict",
                                            "options": {
                                                "access_list_number": {
                                                    "type": "int",
                                                },
                                                "access_list_name": {
                                                    "type": "str",
                                                },
                                            },
                                        },
                                        "threshold": {"type": "int"},
                                        "mpls": {
                                            "type": "dict",
                                            "options": {
                                                "mldp": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                                "default": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                    },
                                },
                                "direct": {"type": "bool"},
                                "log_reuse": {"type": "bool"},
                                "mode": {
                                    "type": "dict",
                                    "options": {"gre": {"type": "bool"}},
                                },
                                "mtu": {"type": "int"},
                                "overlay": {
                                    "type": "dict",
                                    "options": {
                                        "bgp": {
                                            "type": "dict",
                                            "options": {
                                                "shared_tree_prune_delay": {
                                                    "type": "int",
                                                },
                                                "source_tree_prune_delay": {
                                                    "type": "int",
                                                },
                                            },
                                        },
                                        "use_bgp": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "spt_only": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "partitioned": {
                                    "type": "dict",
                                    "options": {
                                        "ingress_replication": {"type": "bool"},
                                        "mldp": {
                                            "type": "dict",
                                            "options": {
                                                "p2mp": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "strict_rpf": {
                                    "type": "dict",
                                    "options": {"interface": {"type": "bool"}},
                                },
                            },
                        },
                        "protection": {
                            "type": "dict",
                            "options": {"local_prefixes": {"type": "bool"}},
                        },
                        "route_replicate": {
                            "type": "dict",
                            "options": {
                                "recursion_policy": {
                                    "type": "dict",
                                    "options": {"destination": {"type": "bool"}},
                                },
                                "from_config": {
                                    "type": "dict",
                                    "options": {
                                        "multicast": {
                                            "type": "dict",
                                            "options": {
                                                "all": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "bgp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "as_number": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "eigrp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "as_number": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "isis": {
                                                    "type": "dict",
                                                    "options": {
                                                        "iso_tag": {"type": "str"},
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "mobile": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "odr": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "ospf": {
                                                    "type": "dict",
                                                    "options": {
                                                        "process_id": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "rip": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "static": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "topology": {
                                                    "type": "dict",
                                                    "options": {
                                                        "base": {
                                                            "type": "dict",
                                                            "options": {
                                                                "all": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "bgp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "eigrp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "isis": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "iso_tag": {
                                                                            "type": "str",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "mobile": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "odr": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "ospf": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "process_id": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "rip": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "static": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "unicast": {
                                            "type": "dict",
                                            "options": {
                                                "all": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "bgp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "as_number": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "connected": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "eigrp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "as_number": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "isis": {
                                                    "type": "dict",
                                                    "options": {
                                                        "iso_tag": {"type": "str"},
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "mobile": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "odr": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "ospf": {
                                                    "type": "dict",
                                                    "options": {
                                                        "process_id": {
                                                            "type": "int",
                                                        },
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "rip": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                                "static": {
                                                    "type": "dict",
                                                    "options": {
                                                        "route_map": {
                                                            "type": "str",
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "vrf": {
                                            "type": "dict",
                                            "options": {
                                                "name": {"type": "str"},
                                                "multicast": {
                                                    "type": "dict",
                                                    "options": {
                                                        "all": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "bgp": {
                                                            "type": "dict",
                                                            "options": {
                                                                "as_number": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "eigrp": {
                                                            "type": "dict",
                                                            "options": {
                                                                "as_number": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "isis": {
                                                            "type": "dict",
                                                            "options": {
                                                                "iso_tag": {
                                                                    "type": "str",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "mobile": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "odr": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "ospf": {
                                                            "type": "dict",
                                                            "options": {
                                                                "process_id": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "rip": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "static": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "topology": {
                                                            "type": "dict",
                                                            "options": {
                                                                "base": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "all": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "bgp": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "as_number": {
                                                                                    "type": "int",
                                                                                },
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "eigrp": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "as_number": {
                                                                                    "type": "int",
                                                                                },
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "isis": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "iso_tag": {
                                                                                    "type": "str",
                                                                                },
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "mobile": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "odr": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "ospf": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "process_id": {
                                                                                    "type": "int",
                                                                                },
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "rip": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                        "static": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "route_map": {
                                                                                    "type": "str",
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                                "unicast": {
                                                    "type": "dict",
                                                    "options": {
                                                        "all": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "bgp": {
                                                            "type": "dict",
                                                            "options": {
                                                                "as_number": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "connected": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "eigrp": {
                                                            "type": "dict",
                                                            "options": {
                                                                "as_number": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "isis": {
                                                            "type": "dict",
                                                            "options": {
                                                                "iso_tag": {
                                                                    "type": "str",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "mobile": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "odr": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "ospf": {
                                                            "type": "dict",
                                                            "options": {
                                                                "process_id": {
                                                                    "type": "int",
                                                                },
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "rip": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                        "static": {
                                                            "type": "dict",
                                                            "options": {
                                                                "route_map": {
                                                                    "type": "str",
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                                "global": {
                                                    "type": "dict",
                                                    "options": {
                                                        "multicast": {
                                                            "type": "dict",
                                                            "options": {
                                                                "all": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "bgp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "eigrp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "isis": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "iso_tag": {
                                                                            "type": "str",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "mobile": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "odr": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "ospf": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "process_id": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "rip": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "static": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "topology": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "base": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "all": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "bgp": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "as_number": {
                                                                                            "type": "int",
                                                                                        },
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "eigrp": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "as_number": {
                                                                                            "type": "int",
                                                                                        },
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "isis": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "iso_tag": {
                                                                                            "type": "str",
                                                                                        },
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "mobile": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "odr": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "ospf": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "process_id": {
                                                                                            "type": "int",
                                                                                        },
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "rip": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                                "static": {
                                                                                    "type": "dict",
                                                                                    "options": {
                                                                                        "route_map": {
                                                                                            "type": "str",
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                        "unicast": {
                                                            "type": "dict",
                                                            "options": {
                                                                "all": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "bgp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "connected": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "eigrp": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "as_number": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "isis": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "iso_tag": {
                                                                            "type": "str",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "mobile": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "odr": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "ospf": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "process_id": {
                                                                            "type": "int",
                                                                        },
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "rip": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                                "static": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "route_map": {
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "route_target": {
                            "type": "dict",
                            "options": {
                                "export": {"type": "str"},
                                "import_config": {"type": "str"},
                                "both": {"type": "str"},
                                "exports": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "rt_value": {"type": "str"},
                                        "stitching": {"type": "bool"},
                                    },
                                },
                                "imports": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "rt_value": {"type": "str"},
                                        "stitching": {"type": "bool"},
                                    },
                                },
                                "both_options": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "rt_value": {"type": "str"},
                                        "stitching": {"type": "bool"},
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "parsed",
                "gathered",
                "deleted",
                "merged",
                "replaced",
                "rendered",
                "overridden",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
