/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintKind;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryColumnSpec
extends SQLQueryNodeModel {
    private static final Map<String, SQLQueryColumnConstraintKind> constraintKindByNodeName = Map.of(STMKnownRuleNames.columnConstraintNotNull, SQLQueryColumnConstraintKind.NOT_NULL, STMKnownRuleNames.columnConstraintUnique, SQLQueryColumnConstraintKind.UNIQUE, STMKnownRuleNames.columnConstraintPrimaryKey, SQLQueryColumnConstraintKind.PRIMARY_KEY, STMKnownRuleNames.referencesSpecification, SQLQueryColumnConstraintKind.REFERENCES, STMKnownRuleNames.checkConstraintDefinition, SQLQueryColumnConstraintKind.CHECK);
    @Nullable
    private final SQLQuerySymbolEntry columnName;
    @Nullable
    private final String typeName;
    @Nullable
    private final SQLQueryValueExpression defaultValueExpression;
    @NotNull
    private final List<SQLQueryColumnConstraintSpec> constraints;

    public SQLQueryColumnSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry columnName, @Nullable String typeName, @Nullable SQLQueryValueExpression defaultValueExpression, @NotNull List<SQLQueryColumnConstraintSpec> constraints) {
        super(syntaxNode.getRealInterval(), syntaxNode, defaultValueExpression);
        this.columnName = columnName;
        this.typeName = typeName;
        this.defaultValueExpression = defaultValueExpression;
        this.constraints = List.copyOf(constraints);
        SQLQueryColumnSpec sQLQueryColumnSpec = this;
        this.constraints.forEach(x$0 -> sQLQueryColumnSpec.registerSubnode((SQLQueryNodeModel)x$0));
    }

    @Nullable
    public SQLQuerySymbolEntry getColumnName() {
        return this.columnName;
    }

    @Nullable
    public String getTypeName() {
        return this.typeName;
    }

    public SQLQueryExprType getDeclaredColumnType() {
        return this.typeName != null ? SQLQueryExprType.forExplicitTypeRef(this.typeName) : SQLQueryExprType.UNKNOWN;
    }

    @Nullable
    public SQLQueryValueExpression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    @NotNull
    public List<SQLQueryColumnConstraintSpec> getConstraints() {
        return this.constraints;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitColumnSpec(this, arg);
    }

    public void resolveRelations(@NotNull SQLQueryRowsSourceContext rowsContext, @Nullable SQLQueryRowsDataContext tableDataContext, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.defaultValueExpression != null && tableDataContext != null) {
            this.defaultValueExpression.resolveRowSources(tableDataContext.getRowsSources(), statistics);
            this.defaultValueExpression.resolveValueRelations(tableDataContext, statistics);
        }
        for (SQLQueryColumnConstraintSpec constraintSpec : this.constraints) {
            constraintSpec.resolveRelations(rowsContext, tableDataContext, statistics);
        }
    }

    public static SQLQueryColumnSpec recognize(SQLQueryModelRecognizer recognizer, STMTreeNode node) {
        SQLQuerySymbolEntry columnName = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.columnName)).map(n -> recognizer.collectIdentifier((STMTreeNode)n, null)).orElse(null);
        String typeName = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.dataType)).map(STMTreeNode::getTextContent).orElse(null);
        STMTreeNode defaultValueNode = node.findFirstChildOfName(STMKnownRuleNames.defaultClause);
        SQLQueryValueExpression defaultValueExpr = defaultValueNode == null ? null : recognizer.collectValueExpression(defaultValueNode, null);
        LinkedList<SQLQueryColumnConstraintSpec> constraints = new LinkedList<SQLQueryColumnConstraintSpec>();
        for (STMTreeNode subnode : node.findChildrenOfName(STMKnownRuleNames.columnConstraintDefinition)) {
            SQLQueryColumnConstraintKind constraintKind;
            SQLQueryComplexName constraintName = Optional.ofNullable(subnode.findFirstChildOfName(STMKnownRuleNames.constraintNameDefinition)).map(n -> n.findFirstChildOfName(STMKnownRuleNames.constraintName)).map(recognizer::collectQualifiedName).orElse(null);
            STMTreeNode constraintNode = Optional.ofNullable(subnode.findFirstChildOfName(STMKnownRuleNames.columnConstraint)).map(STMTreeNode::findFirstNonErrorChild).orElse(null);
            SQLQueryRowsTableDataModel referencedTable = null;
            List<SQLQuerySymbolEntry> referencedColumns = null;
            SQLQueryValueExpression checkExpression = null;
            if (constraintNode != null) {
                constraintKind = constraintKindByNodeName.get(constraintNode.getNodeName());
                switch (constraintKind) {
                    case CHECK: {
                        checkExpression = recognizer.collectValueExpression(constraintNode, null);
                        break;
                    }
                    case REFERENCES: {
                        STMTreeNode refNode = constraintNode.findFirstChildOfName(STMKnownRuleNames.referencedTableAndColumns);
                        if (refNode == null) break;
                        referencedTable = recognizer.collectTableReference(refNode, true);
                        referencedColumns = recognizer.collectColumnNameList(refNode);
                    }
                }
            } else {
                constraintKind = SQLQueryColumnConstraintKind.UNKNOWN;
            }
            constraints.addLast(new SQLQueryColumnConstraintSpec(subnode, constraintName, constraintKind, referencedTable, referencedColumns, checkExpression));
        }
        return new SQLQueryColumnSpec(node, columnName, typeName, defaultValueExpr, constraints);
    }
}

