/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.hover;

import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TabbedPanelTitledTabHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private boolean onlyHighlighted;
    private TabAdapter tabListener = new TabAdapter(){

        @Override
        public void tabAdded(TabEvent event) {
            if (event.getTab() instanceof TitledTab && (!TabbedPanelTitledTabHoverAction.this.onlyHighlighted || TabbedPanelTitledTabHoverAction.this.onlyHighlighted && event.getTab().isHighlighted())) {
                ((TitledTab)event.getTab()).getProperties().addSuperObject(TabbedPanelTitledTabHoverAction.this.titledTabProperties);
            }
        }

        @Override
        public void tabRemoved(TabRemovedEvent event) {
            if (event.getTab() instanceof TitledTab) {
                ((TitledTab)event.getTab()).getProperties().removeSuperObject(TabbedPanelTitledTabHoverAction.this.titledTabProperties);
            }
        }

        @Override
        public void tabHighlighted(TabStateChangedEvent event) {
            if (event.getCurrentTab() != null && event.getCurrentTab() instanceof TitledTab) {
                TabbedPanelTitledTabHoverAction.this.applyTitledTabProperties(event.getTabbedPanel(), (TitledTab)event.getCurrentTab());
            }
        }

        @Override
        public void tabDehighlighted(TabStateChangedEvent event) {
            if (event.getPreviousTab() != null && event.getPreviousTab() instanceof TitledTab) {
                TabbedPanelTitledTabHoverAction.this.removeTitledTabProperties(event.getTabbedPanel(), (TitledTab)event.getPreviousTab());
            }
        }
    };

    public TabbedPanelTitledTabHoverAction() {
        this(false);
    }

    public TabbedPanelTitledTabHoverAction(boolean allTabs) {
        this(new TabbedPanelProperties(), new TitledTabProperties(), allTabs);
    }

    public TabbedPanelTitledTabHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties) {
        this(tabbedPanelProperties, titledTabProperties, false);
    }

    public TabbedPanelTitledTabHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties, boolean allTabs) {
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.titledTabProperties = titledTabProperties;
        this.onlyHighlighted = !allTabs;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    @Override
    public void mouseEntered(HoverEvent event) {
        TabbedPanel tp = (TabbedPanel)event.getSource();
        tp.getProperties().addSuperObject(this.tabbedPanelProperties);
        tp.addTabListener(this.tabListener);
        if (tp.getHighlightedTab() != null && tp.getHighlightedTab() instanceof TitledTab) {
            this.applyTitledTabProperties(tp, (TitledTab)tp.getHighlightedTab());
        } else {
            this.applyTitledTabProperties(tp, null);
        }
    }

    @Override
    public void mouseExited(HoverEvent event) {
        TabbedPanel tp = (TabbedPanel)event.getSource();
        tp.getProperties().removeSuperObject(this.tabbedPanelProperties);
        tp.removeTabListener(this.tabListener);
        if (tp.getHighlightedTab() != null && tp.getHighlightedTab() instanceof TitledTab) {
            this.removeTitledTabProperties(tp, (TitledTab)tp.getHighlightedTab());
        } else {
            this.removeTitledTabProperties(tp, null);
        }
    }

    private void applyTitledTabProperties(TabbedPanel tabbedPanel, TitledTab titledTab) {
        if (this.onlyHighlighted) {
            if (titledTab != null) {
                titledTab.getProperties().addSuperObject(this.titledTabProperties);
            }
        } else {
            int i = 0;
            while (i < tabbedPanel.getTabCount()) {
                Tab tab = tabbedPanel.getTabAt(i);
                if (tab instanceof TitledTab) {
                    ((TitledTab)tab).getProperties().addSuperObject(this.titledTabProperties);
                }
                ++i;
            }
        }
    }

    private void removeTitledTabProperties(TabbedPanel tabbedPanel, TitledTab titledTab) {
        if (this.onlyHighlighted) {
            if (titledTab != null) {
                titledTab.getProperties().removeSuperObject(this.titledTabProperties);
            }
        } else {
            int i = 0;
            while (i < tabbedPanel.getTabCount()) {
                Tab tab = tabbedPanel.getTabAt(i);
                if (tab instanceof TitledTab) {
                    ((TitledTab)tab).getProperties().removeSuperObject(this.titledTabProperties);
                }
                ++i;
            }
        }
    }
}

