/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import org.freeplane.core.ui.menubuilders.menu.IconReplacer;
import org.freeplane.core.ui.menubuilders.menu.JBigButton;
import org.freeplane.core.ui.menubuilders.menu.JButtonWithDropdownMenu;
import org.freeplane.core.ui.menubuilders.menu.JUnitPanel;

public class UnitGridBagLayout
extends GridBagLayout {
    private static final long serialVersionUID = 1L;
    private Component unit;

    private static Component findUnitComponent(Container parent) {
        LayoutManager layout = parent.getLayout();
        if (!(layout instanceof UnitGridBagLayout)) {
            return null;
        }
        UnitGridBagLayout unitLayout = (UnitGridBagLayout)layout;
        for (int i = 0; unitLayout.unit == null && i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            GridBagConstraints constraints = unitLayout.getConstraints(comp);
            String className = comp.getClass().getSimpleName();
            if ((className.equals("JButton") || className.equals("JToggleButton")) && constraints.gridwidth == 1 && constraints.gridheight == 1) {
                unitLayout.unit = comp;
                continue;
            }
            if (!(comp instanceof Container)) continue;
            unitLayout.unit = UnitGridBagLayout.findUnitComponent((Container)comp);
        }
        return unitLayout.unit;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.setPreferredSizes(parent);
        return super.preferredLayoutSize(parent);
    }

    private void setPreferredSizes(Container parent) {
        if (this.unit == null) {
            this.unit = UnitGridBagLayout.findUnitComponent(parent);
        }
        if (this.unit == null) {
            return;
        }
        Dimension unitSize = this.unit.getPreferredSize();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (c == this.unit || !c.isVisible()) continue;
            if (c.getClass().equals(JUnitPanel.class)) {
                c.setPreferredSize(unitSize);
                continue;
            }
            if (!c.getClass().equals(JBigButton.class)) continue;
            c.setPreferredSize(new Dimension(unitSize.width * 7 / 4, unitSize.height));
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.setPreferredSizes(parent);
        super.layoutContainer(parent);
        this.changeSpecialButtonSizes(parent);
    }

    private void changeSpecialButtonSizes(Container parent) {
        block0: for (int i = parent.getComponentCount() - 1; i > 0; --i) {
            Component component = parent.getComponent(i);
            if (!(component instanceof JButtonWithDropdownMenu)) continue;
            int x = component.getX();
            int width = component.getWidth();
            Component previousComponent = parent.getComponent(i - 1);
            while (previousComponent.getX() >= x && previousComponent.getX() + previousComponent.getWidth() <= x + width) {
                previousComponent.setSize(previousComponent.getWidth(), component.getY() - previousComponent.getY());
                if (previousComponent instanceof AbstractButton && !previousComponent.isPreferredSizeSet()) {
                    previousComponent.setPreferredSize(previousComponent.getPreferredSize());
                    IconReplacer.replaceByScaledImageIcon((AbstractButton)previousComponent);
                }
                if (i <= 1) continue block0;
                previousComponent = parent.getComponent(--i - 1);
            }
        }
    }
}

