/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
export interface NetworkLog {
    id: string;
    sessionId?: string;
    timestamp: number;
    method: string;
    url: string;
    headers: Record<string, string | string[] | undefined>;
    body?: string;
    pending?: boolean;
    chunks?: Array<{
        index: number;
        data: string;
        timestamp: number;
    }>;
    response?: {
        status: number;
        headers: Record<string, string | string[] | undefined>;
        body?: string;
        durationMs: number;
    };
    error?: string;
}
export interface ConsoleLogPayload {
    type: 'log' | 'warn' | 'error' | 'debug' | 'info';
    content: string;
}
export interface InspectorConsoleLog extends ConsoleLogPayload {
    id: string;
    sessionId?: string;
    timestamp: number;
}
