/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import generic.jar.ResourceFile;
import ghidra.app.util.demangler.DemangledAddressTable;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.gnu.GnuDemanglerNativeProcess;
import ghidra.app.util.demangler.gnu.GnuDemanglerOptions;
import ghidra.app.util.demangler.gnu.GnuDemanglerParser;
import ghidra.framework.Application;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.IOException;

public class GnuDemangler
implements Demangler {
    private static final String DWARF_REF = "DW.ref.";
    private static final String GLOBAL_PREFIX = "_GLOBAL_";

    public DemanglerOptions createDefaultOptions() {
        return new GnuDemanglerOptions();
    }

    public boolean canDemangle(Program program) {
        String executableFormat = program.getExecutableFormat();
        if (this.isELF(executableFormat) || this.isMacho(executableFormat)) {
            return true;
        }
        String compiler = program.getCompiler();
        if (compiler != null && compiler.contains("gcc")) {
            return true;
        }
        CompilerSpec spec = program.getCompilerSpec();
        String specId = spec.getCompilerSpecID().getIdAsString();
        return !specId.toLowerCase().contains("windows");
    }

    public DemangledObject demangle(MangledContext mangledContext) throws DemangledException {
        DemangledObject demangled = this.demangleInternal(mangledContext);
        if (demangled != null) {
            demangled.setMangledContext(mangledContext);
        }
        return demangled;
    }

    private DemangledObject demangleInternal(MangledContext mangledContext) throws DemangledException {
        GnuDemanglerOptions options;
        DemanglerOptions demanglerOptions = mangledContext.getOptions();
        String mangled = mangledContext.getMangled();
        if (this.skip(mangled, options = this.getGnuOptions(demanglerOptions))) {
            return null;
        }
        String originalMangled = mangled;
        String globalPrefix = null;
        if (mangled.startsWith(GLOBAL_PREFIX)) {
            int index = mangled.indexOf("_Z");
            if (index > 0) {
                globalPrefix = mangled.substring(0, index);
                mangled = mangled.substring(index);
            }
        } else if (mangled.startsWith("__Z")) {
            mangled = mangled.substring(1);
        }
        boolean isDwarf = false;
        if (mangled.startsWith(DWARF_REF)) {
            int len = DWARF_REF.length();
            mangled = mangled.substring(len);
            isDwarf = true;
        }
        try {
            GnuDemanglerNativeProcess process = this.getNativeProcess(options);
            String demangled = process.demangle(mangled, options.getTimeoutSeconds());
            if (demangled == null) {
                throw new DemangledException(false);
            }
            if ((demangled = demangled.trim()).length() == 0 || mangled.equals(demangled)) {
                throw new DemangledException(true);
            }
            DemangledObject demangledObject = this.parse(originalMangled, process, demangled, options);
            if (demangledObject == null) {
                return demangledObject;
            }
            if (globalPrefix != null) {
                DemangledFunction dfunc = new DemangledFunction(originalMangled, demangled, globalPrefix + demangledObject.getName());
                dfunc.setNamespace(demangledObject.getNamespace());
                demangledObject = dfunc;
            }
            if (isDwarf) {
                DemangledAddressTable dat = new DemangledAddressTable(originalMangled, demangled, (String)null, false);
                dat.setSpecialPrefix("DWARF Debug ");
                dat.setName(demangledObject.getName());
                dat.setNamespace(demangledObject.getNamespace());
                return dat;
            }
            return demangledObject;
        }
        catch (IOException e) {
            if (e.getMessage().endsWith("14001")) {
                ResourceFile installationDir = Application.getInstallationDirectory();
                throw new DemangledException("Missing runtime libraries. Please install " + String.valueOf(installationDir) + File.separatorChar + "support" + File.separatorChar + "install_windows_runtime_libraries.exe.");
            }
            throw new DemangledException((Exception)e);
        }
    }

    private GnuDemanglerOptions getGnuOptions(DemanglerOptions options) {
        if (options instanceof GnuDemanglerOptions) {
            return (GnuDemanglerOptions)options;
        }
        return new GnuDemanglerOptions(options);
    }

    private GnuDemanglerNativeProcess getNativeProcess(GnuDemanglerOptions options) throws IOException {
        String demanglerName = options.getDemanglerName();
        String applicationOptions = options.getDemanglerApplicationArguments();
        return GnuDemanglerNativeProcess.getDemanglerNativeProcess(demanglerName, applicationOptions);
    }

    private boolean skip(String mangled, GnuDemanglerOptions options) {
        int index;
        if (mangled.indexOf("@") > 0) {
            return true;
        }
        if (mangled.startsWith("___")) {
            return true;
        }
        if (!options.demangleOnlyKnownPatterns()) {
            return false;
        }
        if (mangled.startsWith(GLOBAL_PREFIX) && (index = mangled.indexOf("_Z")) > 0) {
            return false;
        }
        if (mangled.startsWith("_Z")) {
            return false;
        }
        if (mangled.startsWith("__Z")) {
            return false;
        }
        if (mangled.startsWith("h__")) {
            return false;
        }
        if (mangled.startsWith("?")) {
            return false;
        }
        return !this.isGnu2Or3Pattern(mangled);
    }

    private DemangledObject parse(String mangled, GnuDemanglerNativeProcess process, String demangled, GnuDemanglerOptions options) {
        boolean onlyKnownPatterns = options.demangleOnlyKnownPatterns();
        if (onlyKnownPatterns && !this.isKnownMangledString(mangled, demangled)) {
            return null;
        }
        boolean replaceStdTypedefs = options.shouldUseStandardReplacements();
        GnuDemanglerParser parser = new GnuDemanglerParser();
        DemangledObject demangledObject = parser.parse(mangled, demangled, replaceStdTypedefs);
        return demangledObject;
    }

    private boolean isKnownMangledString(String mangled, String demangled) {
        return !this.isInvalidDoubleUnderscoreString(mangled, demangled);
    }

    private boolean isInvalidDoubleUnderscoreString(String mangled, String demangled) {
        int index = mangled.indexOf("__");
        if (index == -1) {
            return false;
        }
        String leadingText = mangled.substring(0, index);
        return demangled.contains(leadingText);
    }

    private boolean isGnu2Or3Pattern(String mangled) {
        return mangled.startsWith("_GLOBAL_.I.") || mangled.startsWith("_GLOBAL_.D.") || mangled.startsWith("_GLOBAL__I__Z") || mangled.startsWith("_GLOBAL__D__Z");
    }

    private boolean isELF(String executableFormat) {
        return executableFormat != null && executableFormat.indexOf("Executable and Linking Format (ELF)") != -1;
    }

    private boolean isMacho(String executableFormat) {
        return executableFormat != null && executableFormat.indexOf("Mac OS X Mach-O") != -1;
    }
}

