/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractChangeExecutionModelMsSymbol;

public class ChangeExecutionModel32MsSymbol
extends AbstractChangeExecutionModelMsSymbol {
    public static final int PDB_ID = 522;

    public ChangeExecutionModel32MsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader, 32);
        this.parseSpecifics(reader);
    }

    @Override
    public int getPdbId() {
        return 522;
    }

    @Override
    protected String getSymbolTypeName() {
        return "CEXMODEL32";
    }

    protected void parseSpecifics(PdbByteReader reader) throws PdbException {
        switch (this.model) {
            case COBOL: {
                this.subtype = reader.parseUnsignedShortVal();
                this.flag = reader.parseUnsignedShortVal();
                break;
            }
            case PCODE: {
                this.offsetToPcodeFunctionTable = reader.parseUnsignedIntVal();
                this.offsetToSegmentPcodeInformation = reader.parseUnsignedIntVal();
                break;
            }
            case PCODE32MACINTOSH: 
            case PCODE32MACINTOSH_NATIVE_ENTRY_POINT: {
                this.offsetToFunctionTable = reader.parseUnsignedIntVal();
                this.segmentOfFunctionTable = reader.parseUnsignedShortVal();
                break;
            }
        }
    }
}

