/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(ShapeFactory.class);
    protected Function<T, Integer> sizeFunction;
    protected Function<T, Float> aspectRatioFunction;
    private static final Rectangle2D theRectangle = new Rectangle2D.Float();
    private static final Ellipse2D theEllipse = new Ellipse2D.Float();
    private static final RoundRectangle2D theRoundRectangle = new RoundRectangle2D.Float();

    public ShapeFactory(Function<T, Integer> sizeFunction, Function<T, Float> aspectRatioFunction) {
        this.sizeFunction = sizeFunction;
        this.aspectRatioFunction = aspectRatioFunction;
    }

    public ShapeFactory() {
        this(n -> 10, n -> Float.valueOf(1.0f));
    }

    public Shape getRectangle(T t, double rotation) {
        float width = this.sizeFunction.apply(t).intValue();
        float height = width * this.aspectRatioFunction.apply(t).floatValue();
        theRectangle.setFrame(0.0, 0.0, width, height);
        AffineTransform at = new AffineTransform();
        if (rotation != 0.0) {
            at.rotate(rotation);
        }
        at.translate(-width / 2.0f, -height / 2.0f);
        return at.createTransformedShape(theRectangle);
    }

    public Shape getRectangle(T t) {
        return this.getRectangle(t, 0.0);
    }

    public Shape getEllipse(T t) {
        theEllipse.setFrame(this.getRectangle(t).getBounds2D());
        return theEllipse;
    }

    public RoundRectangle2D getRoundRectangle(T t) {
        Rectangle2D frame = this.getRectangle(t).getBounds2D();
        float arc_size = (float)Math.min(frame.getHeight(), frame.getWidth()) / 2.0f;
        theRoundRectangle.setRoundRect(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight(), arc_size, arc_size);
        return theRoundRectangle;
    }

    public Shape getRegularPolygon(T t, int sides, double rotation) {
        GeneralPath thePolygon = new GeneralPath();
        if (sides < 3) {
            throw new IllegalArgumentException("Number of sides must be >= 3");
        }
        Rectangle2D frame = this.getRectangle(t).getBounds2D();
        float width = (float)frame.getWidth();
        float height = (float)frame.getHeight();
        double angle = 0.0;
        thePolygon.reset();
        thePolygon.moveTo(0.0f, 0.0f);
        thePolygon.lineTo(width, 0.0f);
        double theta = Math.PI * 2 / (double)sides;
        for (int i = 2; i < sides; ++i) {
            float delta_x = (float)((double)width * Math.cos(angle -= theta));
            float delta_y = (float)((double)width * Math.sin(angle));
            Point2D prev = thePolygon.getCurrentPoint();
            thePolygon.lineTo((float)prev.getX() + delta_x, (float)prev.getY() + delta_y);
        }
        thePolygon.closePath();
        Rectangle2D r = thePolygon.getBounds2D();
        double scale_x = (double)width / r.getWidth();
        double scale_y = (double)height / r.getHeight();
        float translationX = (float)(r.getMinX() + r.getWidth() / 2.0);
        float translationY = (float)(r.getMinY() + r.getHeight() / 2.0);
        AffineTransform at = AffineTransform.getScaleInstance(scale_x, scale_y);
        if (rotation != 0.0) {
            at.rotate(Math.PI);
        }
        at.translate(-translationX, -translationY);
        return at.createTransformedShape(thePolygon);
    }

    public Shape getRegularPolygon(T t, int sides) {
        return this.getRegularPolygon(t, sides, 0.0);
    }

    public Shape getRegularStar(T t, int points) {
        GeneralPath thePolygon = new GeneralPath();
        if (points < 5) {
            throw new IllegalArgumentException("Number of points must be >= 5");
        }
        Rectangle2D frame = this.getRectangle(t).getBounds2D();
        float width = (float)frame.getWidth();
        float height = (float)frame.getHeight();
        double theta = Math.PI * 2 / (double)points;
        double angle = -theta / 2.0;
        thePolygon.reset();
        thePolygon.moveTo(0.0f, 0.0f);
        float deltaX = width * (float)Math.cos(angle);
        float deltaY = width * (float)Math.sin(angle);
        Point2D currentPoint = thePolygon.getCurrentPoint();
        thePolygon.lineTo((float)currentPoint.getX() + deltaX, (float)currentPoint.getY() + deltaY);
        for (int i = 1; i < points; ++i) {
            deltaX = width * (float)Math.cos(angle += theta);
            deltaY = width * (float)Math.sin(angle);
            currentPoint = thePolygon.getCurrentPoint();
            thePolygon.lineTo((float)currentPoint.getX() + deltaX, (float)currentPoint.getY() + deltaY);
            deltaX = width * (float)Math.cos(angle -= theta * 2.0);
            deltaY = width * (float)Math.sin(angle);
            currentPoint = thePolygon.getCurrentPoint();
            if (currentPoint != null) {
                thePolygon.lineTo((float)currentPoint.getX() + deltaX, (float)currentPoint.getY() + deltaY);
                continue;
            }
            log.error("somehow, currentPoint is null");
        }
        thePolygon.closePath();
        Rectangle2D r = thePolygon.getBounds2D();
        double scaleX = (double)width / r.getWidth();
        double scaleY = (double)height / r.getHeight();
        float translationX = (float)(r.getMinX() + r.getWidth() / 2.0);
        float translationY = (float)(r.getMinY() + r.getHeight() / 2.0);
        AffineTransform at = AffineTransform.getScaleInstance(scaleX, scaleY);
        at.translate(-translationX, -translationY);
        return at.createTransformedShape(thePolygon);
    }
}

