/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class DataTypeComponentImpl
implements InternalDataTypeComponent,
Serializable {
    private static final long serialVersionUID = 1L;
    private DataType dataType;
    private CompositeDataTypeImpl parent;
    private int offset;
    private int ordinal;
    private SettingsImpl defaultSettings;
    private String fieldName;
    private String comment;
    private int length;

    public DataTypeComponentImpl(DataType dataType, CompositeDataTypeImpl parent, int length, int ordinal, int offset, String fieldName, String comment) {
        this.parent = parent;
        this.ordinal = ordinal;
        this.offset = offset;
        this.length = length;
        this.fieldName = InternalDataTypeComponent.cleanupFieldName(fieldName);
        this.setDataType(dataType);
        this.setComment(comment);
        if (this.isZeroBitFieldComponent()) {
            this.length = 0;
        }
    }

    public DataTypeComponentImpl(DataType dataType, CompositeDataTypeImpl parent, int length, int ordinal, int offset) {
        this(dataType, parent, length, ordinal, offset, null, null);
    }

    @Override
    public boolean isBitFieldComponent() {
        return this.dataType instanceof BitFieldDataType;
    }

    @Override
    public boolean isZeroBitFieldComponent() {
        if (this.isBitFieldComponent()) {
            BitFieldDataType bitField = (BitFieldDataType)this.getDataType();
            return bitField.getBitSize() == 0;
        }
        return false;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    boolean containsOffset(int off) {
        if (off == this.offset) {
            return true;
        }
        return off > this.offset && off < this.offset + this.length;
    }

    @Override
    public int getEndOffset() {
        if (this.length == 0) {
            return this.offset;
        }
        return this.offset + this.length - 1;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = StringUtils.isBlank((CharSequence)comment) ? null : comment;
    }

    @Override
    public String getFieldName() {
        if (this.isZeroBitFieldComponent()) {
            return null;
        }
        return this.fieldName;
    }

    @Override
    public void setFieldName(String name) throws DuplicateNameException {
        this.fieldName = InternalDataTypeComponent.cleanupFieldName(name);
    }

    public static void checkDefaultFieldName(String fieldName) throws DuplicateNameException {
        if (fieldName.startsWith("field")) {
            String subname = fieldName.substring("field".length());
            int base = 10;
            if (subname.length() > 3 && subname.startsWith("_0x")) {
                subname = subname.substring(3);
                base = 16;
            }
            if (subname.length() != 0) {
                try {
                    Integer.parseInt(subname, base);
                    throw new DuplicateNameException("Reserved field name: " + fieldName);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataType getParent() {
        return this.parent;
    }

    void update(String name, DataType newDataType, String newComment) {
        this.fieldName = InternalDataTypeComponent.cleanupFieldName(name);
        this.dataType = newDataType;
        this.comment = StringUtils.isBlank((CharSequence)newComment) ? null : newComment;
    }

    @Override
    public void update(int newOrdinal, int newOffset, int newLength) {
        this.ordinal = newOrdinal;
        this.offset = newOffset;
        this.length = newLength;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.defaultSettings == null) {
            DataTypeManager dataMgr = this.parent.getDataTypeManager();
            boolean immutableSettings = dataMgr == null || !dataMgr.allowsDefaultComponentSettings();
            this.defaultSettings = new SettingsImpl(immutableSettings);
            this.defaultSettings.setDefaultSettings(this.getDataType().getDefaultSettings());
        }
        return this.defaultSettings;
    }

    void invalidateSettings() {
        this.defaultSettings = null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        String otherRelPath;
        String myRelPath;
        if (!(obj instanceof DataTypeComponent)) {
            return false;
        }
        DataTypeComponent dtc = (DataTypeComponent)obj;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        if (this.offset != dtc.getOffset() || this.getLength() != dtc.getLength() || this.ordinal != dtc.getOrdinal() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (!(myDt instanceof Pointer) && !(myRelPath = myDt.getPathName()).equals(otherRelPath = otherDt.getPathName())) {
            return false;
        }
        if (myDt instanceof Structure) {
            return otherDt instanceof Structure;
        }
        if (myDt instanceof Union) {
            return otherDt instanceof Union;
        }
        if (myDt instanceof Array) {
            return otherDt instanceof Array;
        }
        if (myDt instanceof Pointer) {
            return otherDt instanceof Pointer;
        }
        if (myDt instanceof TypeDef) {
            return otherDt instanceof TypeDef;
        }
        return myDt.getClass() == otherDt.getClass();
    }

    @Override
    public boolean isEquivalent(DataTypeComponent dtc) {
        boolean aligned;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        DataType myParent = this.getParent();
        boolean bl = aligned = myParent instanceof Composite ? ((Composite)myParent).isPackingEnabled() : false;
        if (!aligned && this.offset != dtc.getOffset() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (this.getLength() != dtc.getLength() && myDt instanceof Dynamic) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(myDt, otherDt);
    }

    @Override
    public void setDataType(DataType dt) {
        this.dataType = dt;
    }

    @Override
    public boolean isUndefined() {
        return this.dataType == DataType.DEFAULT;
    }

    public String toString() {
        return InternalDataTypeComponent.toString(this);
    }

    public static int getPreferredComponentLength(DataType dataType, int length) {
        Dynamic dynamic;
        if (DataTypeComponent.usesZeroLengthComponent(dataType)) {
            return 0;
        }
        if (dataType instanceof Dynamic && (dynamic = (Dynamic)dataType).canSpecifyLength()) {
            return length;
        }
        int dtLength = dataType.getLength();
        if (length <= 0) {
            length = dtLength;
        } else if (dtLength >= 0 && dtLength < length) {
            length = dtLength;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Positive length must be specified for " + dataType.getDisplayName() + " component");
        }
        return length;
    }
}

